<?php $__env->startSection('content'); ?>
    <style>
        /* Custom styles for subtle enhancements */
        .card {
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        .section-title {
            font-family: 'Inter', sans-serif;
            font-weight: 600;
        }
    </style>

    <div class="p-6 mt-10 max-w-7xl mx-auto">
        <!-- Dashboard Header -->
        <div class="mb-8 flex flex-row gap-5">
            <h1 class="text-3xl font-bold text-gray-800 section-title">School Dashboard</h1>
            <a href="<?php echo e(route('pdf.dashboard')); ?>" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                Download PDF
            </a>
        </div>


        <!-- Overview Section -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
            <!-- Student Applications -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Student Applications</h2>
                <div class="flex justify-between items-center">
                    <div class="space-y-3">
                        <p class="flex items-center gap-2">
                            <span class="inline-block w-3 h-3 bg-green-500 rounded-full"></span>
                            <span class="text-gray-700 font-medium">Accepted:</span>
                            <span class="text-green-600 font-bold"><?php echo e($accept ?? 'N/A'); ?></span>
                        </p>
                        <p class="flex items-center gap-2">
                            <span class="inline-block w-3 h-3 bg-red-500 rounded-full"></span>
                            <span class="text-gray-700 font-medium">Rejected:</span>
                            <span class="text-red-600 font-bold"><?php echo e($reject ?? 'N/A'); ?></span>
                        </p>
                        <p class="flex items-center gap-2">
                            <span class="inline-block w-3 h-3 bg-yellow-400 rounded-full"></span>
                            <span class="text-gray-700 font-medium">Pending:</span>
                            <span class="text-yellow-500 font-bold"><?php echo e($pending ?? 'N/A'); ?></span>
                        </p>
                    </div>
                    <div class="bg-indigo-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/applications.png')); ?>" alt="Applications" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Students Overview -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Students Overview</h2>
                <div class="flex justify-between items-center">
                    <div class="space-y-3">
                        <p class="flex items-center gap-2">
                            <span class="text-green-500">🟢</span>
                            <span class="text-gray-700 font-medium">Active:</span>
                            <span class="text-gray-800 font-bold"><?php echo e($totalStudents ?? 'N/A'); ?></span>
                        </p>
                        <p class="flex items-center gap-2">
                            <span class="text-orange-500">🟠</span>
                            <span class="text-gray-700 font-medium">Alumni:</span>
                            <span class="text-gray-800 font-bold"><?php echo e($totalAlumni ?? 'N/A'); ?></span>
                        </p>
                    </div>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/students-overview.png')); ?>" alt="Students Overview"
                            class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Other Income -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Other Income</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format(-($totalOtherIncome ?? 0.0), 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/alumni.png')); ?>" alt="Other Income" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Income -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Income</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format(-($incomeFromStd ?? 0.0), 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/alumni.png')); ?>" alt="Income" class="w-6 h-6">
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Metrics Section -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
            <!-- Cash in Hand -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Cash in Hand</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format($cashInHandBalance ?? 0.0, 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/students-overview.png')); ?>" alt="Cash in Hand" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Student Dues -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Student Dues</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format($studentDue ?? 0.0, 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/applications.png')); ?>" alt="Student Dues" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Expense -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Expense</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format($totalExpense ?? 0.0, 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/alumni.png')); ?>" alt="Expense" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!--Salary Expense -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Salary Expense</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format($totalSalaryExpense ?? 0.0, 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/alumni.png')); ?>" alt="Expense" class="w-6 h-6">
                    </div>
                </div>
            </div>

            <!-- Payable -->
            <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-5">
                <h2 class="text-lg font-semibold text-gray-800 section-title">Payable</h2>
                <div class="flex justify-between items-center">
                    <p class="text-2xl font-bold text-gray-800"><?php echo e(number_format(-($payable ?? 0.0), 2)); ?></p>
                    <div class="bg-gray-100 p-3 rounded-full">
                        <img src="<?php echo e(asset('assets/sidebar/alumni.png')); ?>" alt="Payable" class="w-6 h-6">
                    </div>
                </div>
            </div>
        </div>

        <!-- Student Counts Section -->
        <div class="mb-10">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php $__currentLoopData = $stdCountClass; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-4">
                        <h2 class="text-lg font-semibold text-gray-800 section-title"><?php echo e($item->name ?? 'N/A'); ?></h2>
                        <p class="text-lg font-semibold text-gray-800 section-title">Active Students: <span
                                class="font-bold text-gray-800"><?php echo e($item->active_count ?? 'N/A'); ?></span></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div class="mb-10">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white p-6 rounded-xl shadow-lg card flex flex-col gap-4">
                        <h2 class="text-lg font-semibold text-gray-800 section-title">
                            <?php echo e(ucfirst($position->title ?? 'N/A')); ?>

                        </h2>
                        <p class="text-lg font-semibold text-gray-800 section-title">Active: <span
                                class="font-bold text-gray-800"><?php echo e($position->active_count ?? 'N/A'); ?></span></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/dashboard.blade.php ENDPATH**/ ?>