<?php $__env->startSection('content'); ?>
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
      <?php echo $__env->make('student.stdProfilePartials', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

      <!-- Tabs Section -->
      <div
        class="flex justify-between mt-4 w-full px-4 bg-white pt-2 border-b border-gray-200 items-center"
      >
        <div class="flex space-x-4 bg-white">
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='<?php echo e(route('student.profile',$student->id)); ?>'">
            Admission & Personal Details
          </button>
          <button
            class="tab-btn px-4 pb-4 bg-white pt-2 border-b-2 border-blue-500 font-semibold text-blue-500"
          >
            Academic Information
          </button>
          
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='<?php echo e(route('student.profile.attendance', $student->id)); ?>'">
            Attendance Records
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='<?php echo e(route('student.profile.documents',$student->id)); ?>'">
              Documents & Certificates
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='<?php echo e(route('student.profile.promote', $student->id)); ?>'">
                    Promote Student
                </button>
        </div>
      </div>

      <div class="flex gap-6 mt-10">
        <!-- Left Section (70%) -->
        <div class="w-[70%] bg-white shadow">
          <div class="flex justify-between pt-6 px-6 items-center">
            <h2 class="text-xl font-semibold mb-4">Course & Subjects</h2>

            
          </div>

          <!-- Table -->
          <table class="w-full border-collapse">
            <thead class="bg-[#f9fafc]">
              <tr class="text-gray-600">
                <th class="p-3 text-left font-medium">Subject</th>
                <th class="p-3 text-left font-medium">Teacher</th>
                <th class="p-3 text-left font-medium">Schedule</th>
              </tr>
            </thead>
            <tbody class="bg-white py-3 rounded-lg">
              <?php if($subjects): ?>
                <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  
                <tr class="border-b">
                  <td class="p-3 flex items-center font-semibold text-black">
                    <?php echo e($subject->subjects->name); ?>

                  </td>
                  <td class="p-3 text-gray-500"><?php echo e($subject->staff_member->full_name); ?></td>
                  <td class="p-3 text-gray-500"><?php echo e($subject->start_time); ?> <?php echo e($subject->end_time); ?></td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              <?php endif; ?>
            </tbody>
          </table>
        </div>

        <!-- Right Section (30%) -->
        <div
          class="w-[30%] bg-white min-h-44 p-6 shadow rounded-lg self-start flex-grow-0"
        >
          <h2 class="text-xl font-semibold mb-2">Class Information</h2>
          <div class="mt-2">
            <h3 class="text-gray-400 text-md">Current Class</h3>
            <?php
              $admission = $student->admissions->first();
            ?>

            <p class="text-xl"><?php echo e($admission->class->name); ?></p>
          </div>
          
          <div class="mt-2">
            <h3 class="text-gray-400 text-md">Academic Year</h3>
            <p class="text-xl"><?php echo e($student->latestAdmission->session_year); ?></p>
          </div>
        </div>
      </div>

      <!-- Second Section - Weekly Schedule -->
      
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/student/academic-information.blade.php ENDPATH**/ ?>