<div
        class="p-6 w-full bg-white rounded-lg shadow-sm flex justify-between items-center"
      >
        <!-- Left Section: Profile Image + Student Info -->
        <div class="flex items-center gap-x-4">
          <img
          src="<?php echo e($student->documents && $student->documents->photo ? url('/student-image/' . $student->documents->photo) : asset('assets/sidebar/student.png')); ?>"

            alt="Student Profile"
            class="w-28 h-28 rounded-full object-cover border"
          />
          
          <div>
            <h2 class="text-xl font-bold"><?php echo e($student->student_name); ?></h2>
            <p class="text-gray-500 mb-2"><?php echo e($student->email); ?></p>
            <p class="text-gray-500 mb-2"><?php echo e($student->reg_no); ?></p>
            <p class="text-gray-600">Class: <?php echo e($student->classes->first()->name); ?> - Section <?php echo e($student->sections->first()->name); ?></p>
            <p class="text-gray-600">Contact: <?php echo e($student->emergencyContact->contact_number); ?></p>
            <p class="text-gray-600 mt-2">
              <span
                class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm"
              >
               <?php echo e($student->status); ?>

              </span>
            </p>
          </div>
        </div>

        <!-- Right Section: Buttons -->
        <div class="flex space-x-4">
          <button
            class="px-4 py-2 border border-gray-400 bg-white text-gray-600 flex items-center space-x-2" onclick="location.href='<?php echo e(route('student.edit', $student->id)); ?>'"
          >
            <i class="fas fa-edit"></i>
            <span>Edit Profile</span>
          </button>
        </div>
      </div><?php /**PATH C:\xamp\htdocs\REMS\resources\views/student/stdProfilePartials.blade.php ENDPATH**/ ?>