<?php $__env->startSection('content'); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://kit.fontawesome.com/ee244dc737.js" crossorigin="anonymous"></script>
    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <!-- Success and Error Messages -->
        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                <span class="absolute top-0 bottom-0 right-0 px-4 py-3" onclick="this.parentElement.style.display='none'">
                    <i class="fa-solid fa-xmark cursor-pointer"></i>
                </span>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                <span class="absolute top-0 bottom-0 right-0 px-4 py-3" onclick="this.parentElement.style.display='none'">
                    <i class="fa-solid fa-xmark cursor-pointer"></i>
                </span>
            </div>
        <?php endif; ?>
        <div class="bg-white border border-gray-200  rounded-md shadow-sm">
            <div class="flex justify-between px-4 pt-4 bg-white py-2 items-center">
                <!-- Page Title -->
                <h1 class="text-2xl font-semibold px-2">Fee Structure</h1>

                <!-- Buttons -->
                <div class="flex gap-3">
                    <!-- PDF Button -->
                    <a href="<?php echo e(route('pdf.student.fee.structure')); ?>"
                        class="px-4 py-2 bg-[#0197FF] hover:bg-blue-700 text-white rounded-lg">
                         PDF
                    </a>

                    <!-- Create Button -->
                    <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-2 text-white rounded-lg text-sm"
                        onclick="openModal()">
                        <i class="fa-solid fa-plus"></i>
                        <span>Create new fee structure</span>
                    </button>
                </div>
            </div>

            <div class="rounded-lg">
                <div class="bg-white py-3 rounded-lg relative">
                    <table class="w-full border-collapse ">
                        <thead class="bg-[#f9fafc] w-full">
                            <tr>
                                <th class="p-3 text-left font-medium text-gray-500">Class</th>

                                <th class="p-3 text-left font-medium text-gray-500">
                                    Admission Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Promotion Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Tuition Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Lab Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Exam Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Board Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Entertainment Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Other Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Books Charges
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Annual Charges
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Second Time Fee
                                </th>
                                <th class="p-3 text-left font-medium text-gray-500">
                                    Actions
                                </th>
                            </tr>
                        </thead>

                        <tbody class="w-full">

                            <?php if(!empty($structures) && $structures->count()): ?>
                                <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-b">
                                        <td class="p-3 text-left text-gray-500 text-nowrap"><?php echo e($structure->class->name); ?>

                                        </td>
                                        <?php if($amounts): ?>
                                            <?php $__currentLoopData = $amounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($amount->class_id == $structure->class_id): ?>
                                                    <?php if($amount->fee_type == 'admission_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'promotion_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'tuition_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'lab_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'exam_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'board_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'entertainment_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'other_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'books_charges'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'annual_charges'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                    <?php if($amount->fee_type == 'second_time_fee'): ?>
                                                        <td class="p-3 text-left text-gray-500">
                                                            Rs. <?php echo e($amount->amount); ?>

                                                        </td>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <?php continue; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td>
                                                <i class="fa-solid fa-pen-to-square cursor-pointer"
                                                    onclick="openEditModal(<?php echo e($structure->class_id); ?>)"
                                                    data-class-id="<?php echo e($structure->class_id); ?>">
                                                </i>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="13" class="p-3 text-center text-gray-500">No fee structures found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <!-- Pagination -->
                    <?php if(!empty($structures) && $structures->count()): ?>
                        <?php echo e($structures->links('vendor.pagination.custom-pagination')); ?>

                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>


    
    <div id="createNewFeeModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50">
        <form action="<?php echo e(route('store.fee.structure')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="bg-white rounded-lg shadow-md w-full max-w-xl min-h-[80vh] max-h-[80vh] overflow-y-auto relative">
                <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                    <h2 class="text-xl font-semibold">Create New Fee Structure</h2>
                    <button type="button" id="closeModal" class="text-gray-600 hover:text-gray-900">
                        <i class="fa-solid fa-xmark"></i>
                    </button>
                </div>

                <div class="bg-white px-6 py-2 w-full">
                    <div class="mb-4">
                        <label class="block text-gray-700 font-medium mb-1">
                            Class <span class="text-red-500">*</span>
                        </label>
                        <select name="class_id"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Class</option>
                            <?php if(!empty($classes) && $classes->count()): ?>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Admission Fee <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="fee_type[admission_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Promotion Fee
                            </label>
                            <input type="text" name="fee_type[promotion_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Tuition Fee <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="fee_type[tuition_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Lab Fee
                            </label>
                            <input type="text" name="fee_type[lab_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Exam Fee
                            </label>
                            <input type="text" name="fee_type[exam_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Board Fee
                            </label>
                            <input type="text" name="fee_type[board_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Entertainment Fee
                            </label>
                            <input type="text" name="fee_type[entertainment_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Other Fee
                            </label>
                            <input type="text" name="fee_type[other_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Books Charges
                            </label>
                            <input type="text" name="fee_type[books_charges]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                        <div>
                            <label class="block text-gray-700 font-medium mb-1">
                                Annual Charges
                            </label>
                            <input type="text" name="fee_type[annual_charges]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>

                        <div class="md:col-span-2">
                            <label class="block text-gray-700 font-medium mb-1">
                                Second Time Fee
                            </label>
                            <input type="text" name="fee_type[second_time_fee]" placeholder="Rs. .00"
                                class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500" />
                        </div>
                    </div>
                </div>

                <div class="flex justify-end mt-4 border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" id="closeModalBtn"
                        class="px-4 py-2 border border-gray-300 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Save
                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 ">
        <form action="<?php echo e(route('update.fee.structure')); ?>" method="POST" class="">
            <div
                class="bg-white rounded-lg shadow-md w-full max-w-xl min-h-[80vh] max-h-[80vh] overflow-y-auto relative px-4 py-6">

                <div class="bg-white rounded-lg shadow-md w-full max-w-xl p-6">
                    <h2 class="text-xl font-semibold mb-4">Edit Fee Structure</h2>
                </div>

                <?php echo csrf_field(); ?>
                <input type="hidden" id="editClassId" name="class_id">

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- Admission Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Admission Fee</label>
                        <input type="text" id="editAdmissionFee" name="fee_type[admission_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Promotion Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Promotion Fee</label>
                        <input type="text" id="editPromotionFee" name="fee_type[promotion_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Tuition Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Tuition Fee</label>
                        <input type="text" id="editTuitionFee" name="fee_type[tuition_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Lab Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Lab Fee</label>
                        <input type="text" id="editLabFee" name="fee_type[lab_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Exam Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Exam Fee</label>
                        <input type="text" id="editExamFee" name="fee_type[exam_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Board Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Board Fee</label>
                        <input type="text" id="editBoardFee" name="fee_type[board_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Entertainment Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Entertainment Fee</label>
                        <input type="text" id="editEntertainmentFee" name="fee_type[entertainment_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Other Fee -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Other Fee</label>
                        <input type="text" id="editOtherFee" name="fee_type[other_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Books Charges -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Books Charges</label>
                        <input type="text" id="editBooksCharges" name="fee_type[books_charges]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Annual Charges -->
                    <div>
                        <label class="block text-gray-700 font-medium mb-1">Annual Charges</label>
                        <input type="text" id="editAnnualCharges" name="fee_type[annual_charges]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                    <!-- Second Time Fee -->
                    <div class="md:col-span-2">
                        <label class="block text-gray-700 font-medium mb-1">Second Time Fee</label>
                        <input type="text" id="editSecondTimeFee" name="fee_type[second_time_fee]"
                            class="w-full border border-gray-300 rounded-lg px-3 py-2">
                    </div>
                </div>

                <div class="flex justify-end mt-4 space-x-3">
                    <button type="button" onclick="closeEditModal()"
                        class="px-4 py-2 border border-gray-300 text-gray-800 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded">Save</button>
                </div>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function openModal() {
            document.getElementById("createNewFeeModal").classList.remove("hidden");
        }

        function closeModal() {
            document.getElementById("createNewFeeModal").classList.add("hidden");
        }


        document
            .getElementById("closeModal")
            .addEventListener("click", closeModal);
        document
            .getElementById("closeModalBtn")
            .addEventListener("click", closeModal);

        // edit modole

        function openEditModal(classId) {
            // Fetch fee structure data for the selected class
            fetch(`/fee-structure/${classId}/edit`)
                .then(response => response.json())
                .then(data => {
                    // Populate the edit modal with the fetched data
                    document.getElementById('editClassId').value = data.class_id;
                    document.getElementById('editAdmissionFee').value = data.fee_type.admission_fee || '';
                    document.getElementById('editPromotionFee').value = data.fee_type.promotion_fee || '';
                    document.getElementById('editTuitionFee').value = data.fee_type.tuition_fee || '';
                    document.getElementById('editLabFee').value = data.fee_type.lab_fee || '';
                    document.getElementById('editExamFee').value = data.fee_type.exam_fee || '';
                    document.getElementById('editBoardFee').value = data.fee_type.board_fee || '';
                    document.getElementById('editEntertainmentFee').value = data.fee_type.entertainment_fee || '';
                    document.getElementById('editOtherFee').value = data.fee_type.other_fee || '';
                    document.getElementById('editBooksCharges').value = data.fee_type.books_charges || '';
                    document.getElementById('editAnnualCharges').value = data.fee_type.annual_charges || '';
                    document.getElementById('editSecondTimeFee').value = data.fee_type.second_time_fee || '';

                    // Open the edit modal
                    document.getElementById('editModal').classList.remove('hidden');
                })
                .catch(error => {
                    console.error('Error fetching fee structure:', error);
                });
        }


        function closeEditModal() {
            document.getElementById('editModal').classList.add('hidden');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/stdFeeMgt/fee-structure.blade.php ENDPATH**/ ?>