<?php $__env->startSection('content'); ?>
    <div class="w-full mx-auto bg-[#f9fafc] mt-10 p-8 rounded-lg shadow-md">
        <h2 class="text-2xl mb-6">Update Settings</h2>

        <form action="<?php echo e(route('settings.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4">
                    <strong class="font-bold">Error:</strong>
                    <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                    <strong class="font-bold">Success:</strong>
                    <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="flex">
                    <?php if(!empty($logo->setting_value)): ?>
                        
                        <img src="<?php echo e(url('school-logo/'.$logo->setting_value)); ?>" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1"><?php echo e(ucfirst(str_replace('_', ' ', $logo->setting_key))); ?></label>
                            <input type="file" name="school_logo"
                                class="w-full p-2 border rounded">
                        </div>
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1"><?php echo e(ucfirst(str_replace('_', ' ', 'school_logo'))); ?></label>
                            <input type="file" name="school_logo"
                                class="w-full p-2 border rounded">
                        </div>
                    <?php endif; ?>
                    
                        
                </div>
                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <label class="block mb-1"><?php echo e(ucfirst(str_replace('_', ' ', $setting->setting_key))); ?></label>
                        <input type="text" name="settings[<?php echo e($setting->setting_key); ?>]"
                            class="w-full p-2 border rounded <?php $__errorArgs = ['settings.' . $setting->setting_key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('settings.' . $setting->setting_key, $setting->setting_value)); ?>">
                        <?php $__errorArgs = ['settings.' . $setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <div class="flex">
                    <?php if(!empty($controller_signature->setting_value)): ?>
                        <img src="<?php echo e(url('school-logo/'.$controller_signature->setting_value)); ?>" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1"><?php echo e(ucfirst(str_replace('_', ' ', $controller_signature->setting_key))); ?></label>
                            <input type="file" name="exam_controller_sign"
                                class="w-full p-2 border rounded">
                        </div>
                    <?php endif; ?>
                         
                </div>

            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Update Settings</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/settings/index.blade.php ENDPATH**/ ?>