<?php $__env->startSection('content'); ?>
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
      <?php echo $__env->make('student.stdProfilePartials', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

      <!-- Tabs Section -->
      <div
        class="flex justify-between mt-4 w-full px-4 bg-white pt-2 border-b border-gray-200 items-center"
      >
        <div class="flex space-x-4 bg-white">
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='<?php echo e(route('student.profile',$student->id)); ?>'">
            Admission & Personal Details
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="window.location.href='<?php echo e(route('student.profile.academic',$student->id)); ?>'">
            Academic Information
          </button>
          
          <button
            class="tab-btn px-4 pb-4 bg-white pt-2 border-b-2 border-blue-500 font-semibold text-blue-500"
          >
            Attendance Records
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='<?php echo e(route('student.profile.documents',$student->id)); ?>'">
            Documents & Certificates
          </button>
        </div>
      </div>

      <div class="grid mt-4 grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
        <!-- Present Goal Card -->
        <div
          class="bg-white p-4 shadow-sm rounded-lg border border-gray-200 flex items-center"
        >
          <span class="text-[#1B9AF5] rounded-lg text-xl">
            <i class="fa-solid fa-calendar-check"></i>
          </span>
          <div class="ml-3">
            <h3 class="text-gray-600 text-sm">Present Goal</h3>
            <p class="text-lg font-semibold text-gray-800"><?php echo e($attendances?->where('status','present')->count()?? 0); ?>/<?php echo e($attendances->count()); ?></p>
          </div>
        </div>

        <!-- Revised Days Card -->
        <div
          class="bg-white p-4 shadow-sm rounded-lg border border-gray-200 flex items-center"
        >
          <span class="text-green-700 rounded-lg text-xl">
            <i class="fa-solid fa-calendar-xmark"></i>
          </span>
          <div class="ml-3">
            <h3 class="text-gray-600 text-sm">Absent Days</h3>
            <p class="text-lg font-semibold text-gray-800"><?php echo e($attendances?->where('status','absent')->count() ?? 0); ?>/<?php echo e($attendances->count()); ?></p>
          </div>
        </div>

        <!-- Late Action Card -->
        <div
          class="bg-white p-4 shadow-sm rounded-lg border border-gray-200 flex items-center"
        >
          <span class="text-[#EAB308] rounded-lg text-xl">
            <i class="fa-solid fa-clock"></i>
          </span>
          <div class="ml-3">
            <h3 class="text-gray-600 text-sm">Half Day Leave</h3>
            <p class="text-lg font-semibold text-gray-800"><?php echo e($attendances?->where('status','half_day')->count() ?? 0); ?>/<?php echo e($attendances->count()); ?></p>
          </div>
        </div>

        <!-- Lease Days Card -->
        <div
          class="bg-white p-4 shadow-sm rounded-lg border border-gray-200 flex items-center"
        >
          <span class="text-yellow-700 rounded-lg text-xl">
            <i class="fa-solid fa-file"></i>
          </span>
          <div class="ml-3">
            <h3 class="text-gray-600 text-sm">Leave Days</h3>
            <p class="text-lg font-semibold text-gray-800"><?php echo e($attendances?->where('status','leave')->count() ?? 0); ?>/<?php echo e($attendances->count()); ?></p>
          </div>
        </div>
      </div>

      <div class="bg-white border border-gray-200 rounded-lg mt-8">
        <!-- Label and Select Input -->
        <div
          class="flex px-4 py-3 rounded-xl justify-between items-center"
        >
          <p class="text-lg font-semibold">Attendance Records</p>
          <select
            class="border w-[140px] border-gray-300 rounded px-2 py-2 focus:outline-none focus:ring focus:ring-blue-300"
            id="month"
          >
          <option value="">Select Month</option>
          <?php
            $months = $attendances->pluck('date')->map(function ($date) {
                return \Carbon\Carbon::parse($date)->month;
            })->unique()->sort();
          ?>
          <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($month); ?>" <?php echo e(request('month') == $month ? 'selected' : ''); ?>>
            <?php echo e(\Carbon\Carbon::create()->month($month)->format('F')); ?>

            </option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <table class="w-full border-collapse">
          <thead class="bg-[#f9fafc]">
            <tr class="text-gray-600">
              <th class="p-3 text-left font-semibold">Date</th>
              <th class="p-3 text-left font-semibold">Status</th>
              <th class="p-3 text-left font-semibold">Remarks</th>
            </tr>
          </thead>
          <tbody>

            <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-b">
              <td class="p-3 text-black"><?php echo e(\Carbon\Carbon::parse($attendance->date)->format('d M Y')); ?></td>
              <td class="p-3 text-gray-800">
                <?php if($attendance->status === 'present'): ?>
                  <span class="bg-[#DCFCE7] text-[#166534] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                    <i class="fa-solid fa-circle-check"></i> Present
                  </span>
                <?php elseif($attendance->status === 'absent'): ?>
                  <span class="bg-[#FEE2E2] text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                    <i class="fa-solid fa-circle-xmark"></i> Absent
                  </span>
                <?php elseif($attendance->status === 'late'): ?>
                  <span class="bg-[#FEF9C3] text-[#854D0E] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                    <i class="fas fa-clock"></i> Late
                  </span>
                <?php endif; ?>
              </td>
              <td class="p-3 text-gray-600"><?php echo e($attendance->remarks ?? 'N/A'); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
          </tbody>
        </table>

        
         
      </div>
    </div>
    <script>
    document.getElementById('month').addEventListener('change', function () {
      const selectedMonth = this.value;
      const studentId = <?php echo e($student->id); ?>;
      const url = '/std/profile/attendance/'+studentId+'/month/'+selectedMonth;
      window.location.href = url;
    });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/student/attendance-records.blade.php ENDPATH**/ ?>