<?php $__env->startSection('content'); ?>
    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline"><?php echo e(session('error')); ?></span>
        </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button onclick="window.location.href='<?php echo e(route('show.attendance')); ?>'"
                    class="tab-btn pb-3 text-gray-700 font-semibold">
                    Student Attendance
                </button>
                <button onclick="window.location.href='<?php echo e(route('attendance.report')); ?>'"
                    class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Attendance Report
                </button>
            </div>
        </div>

        <form method="GET" action="<?php echo e(route('attendance.report')); ?>">

            <div class="flex justify-between items-center bg-white p-4 shadow-sm rounded-lg">
                <!-- Left Side - Select Inputs -->

                <div class="flex gap-4">

                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Year</label>
                        <select required name="year" class="border p-2 min-w-[100px] rounded-lg">
                            <option disabled selected>Year</option>
                            <?php for($y = now()->year; $y >= now()->year - 3; $y--): ?>
                                <option value="<?php echo e($y); ?>" <?php echo e(request('year') == $y ? 'selected' : ''); ?>>
                                    <?php echo e($y); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Month</label>
                        <select required name="month" class="border p-2 min-w-[100px] rounded-lg">
                            <option disabled selected>Month</option>
                            <?php for($m = 1; $m <= 12; $m++): ?>
                                <option value="<?php echo e(str_pad($m, 2, '0', STR_PAD_LEFT)); ?>"
                                    <?php echo e(request('month') == str_pad($m, 2, '0', STR_PAD_LEFT) ? 'selected' : ''); ?>>
                                    <?php echo e(\Carbon\Carbon::create()->month($m)->format('F')); ?>

                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>


                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Class</label>
                        <select required name="class_id" class="border p-2 min-w-[100px] rounded-lg">
                            <option value="">Select Class</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->id); ?>"
                                    <?php echo e(request('class_id') == $class->id ? 'selected' : ''); ?>>
                                    <?php echo e($class->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Section</label>
                        <select name="section_id" class="border p-2 min-w-[150px] rounded-sm">
                            <option value="">Select Section</option>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"
                                    <?php echo e(request('section_id') == $section->id ? 'selected' : ''); ?>>
                                    Section <?php echo e($section->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                </div>

                <!-- Right Side - Buttons -->
                <div class="flex gap-2">
                    <button class="bg-[#0197FF] text-white px-6 py-2 rounded-sm hover:bg-blue-600">
                        Apply Filters
                    </button>
                    <button class="bg-white border border-gray-400 text-gray-700 px-6 py-2 rounded-sm font-medium">
                        Reset
                    </button>
                </div>

            </div>
        </form>
        <div class="mt-4 bg-white shadow-sm rounded-lg">
            <div class="flex justify-between items-center p-4">
                <!-- Left Side - Heading -->
                <h2 class="text-lg font-semibold text-gray-700">Detailed Report</h2>

                <!-- Right Side - Buttons -->
                <div class="flex gap-2">
                    <!-- <button
                  class="flex items-center gap-2 border border-gray-400 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-100"
                >
                <a href="<?php echo e(request()->fullUrlWithQuery(['export' => 'excel'])); ?>" class="btn btn-outline-success">
                    <i class="fa fa-file-excel"></i> Export Excel
                </a>
                </button> -->
                    <button
                        class="flex items-center gap-2 border border-gray-400 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-100">
                        <a href="<?php echo e(request()->fullUrlWithQuery(['export' => 'pdf'])); ?>" class="btn btn-outline-danger">
                            <i class="fa fa-file-pdf"></i> Export PDF
                        </a>
                    </button>
                </div>
            </div>
            <div class="mt-4">
                <table class="w-full bg-white border-gray-300">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-left text-gray-800 font-medium">
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Student
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Roll No
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">Class</th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Present
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Absent
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">Leave</th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Attendance %
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Row 1 -->
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-b">
                                <td class="p-3 justify-center flex items-center space-x-3">
                                    <img src="<?php echo e($student->documents && $student->documents->photo ? asset('storage/' . $student->documents->photo) : asset('assets/sidebar/student.png')); ?>"
                                        alt="Student" class="w-10 h-10 rounded-full" />
                                    <p class="font-medium"><?php echo e($student->student_name); ?></p>
                                </td>
                                <td class="p-3 text-center text-gray-600"> <?php echo e($student->latestAdmission->roll_number); ?>

                                </td>
                                <td class="p-3 text-center text-gray-600"><?php echo e($student->classes->first()->name); ?> -
                                    Section-<?php echo e($student->sections->first()->name); ?></td>
                                <td class="p-3 text-center text-gray-600"><?php echo e($student->present_count); ?></td>
                                <td class="p-3 text-center text-gray-600"><?php echo e($student->absent_count); ?></td>
                                <td class="p-3 text-center text-gray-600"><?php echo e($student->leave_count); ?></td>
                                <td class="p-3 text-center text-gray-600">
                                    <span class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                        <?php
                                            $present = $student->present_count ?? 0;
                                            $total = $student->total_attendance_count ?? 0;
                                            $percent = $total > 0 ? round(($present / $total) * 100, 1) : 0;
                                        ?>

                                        <?php echo e($percent); ?>%

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="flex bg-white mt-10 border-t border-gray-200 justify-between items-center p-4">
                    <div class="flex justify-between items-center mt-4">

                    </div>

                    <div class="flex space-x-2">
                        <?php echo e($students->links('vendor.pagination.custom-pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/stdAttendance/stdAttendReport.blade.php ENDPATH**/ ?>