<?php $__env->startSection('content'); ?>
    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <?php echo $__env->make('successError', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="flex justify-between items-center">
            <div class="flex space-x-4 border-b border-gray-200 w-[50%]">
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Current Staffs
                </button>
                <button class="tab-btn pb-3 text-gray-700 font-semibold"
                    onclick="window.location.href='<?php echo e(route('staff.past')); ?>'">
                    Past Staffs
                </button>
            </div>

            <!-- Wrap PDF and New Staff buttons in a flex container -->
            <div class="flex gap-x-4 items-center">
                <button class="bg-[#0197FF] px-4 py-2 hover:bg-blue-600 items-center text-white rounded"
                    onclick="window.location.href = '<?php echo e(route('staff.active.pdf')); ?>'">
                    <span>PDF</span>
                </button>
                <!-- New Staff Member Button -->
                <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
                    onclick="window.location.href = '<?php echo e(route('staff.create')); ?>'">
                    <img src="<?php echo e(asset('assets/new.png')); ?>" alt="icon" />
                    <span>New Staff</span>
                </button>
            </div>
        </div>


        <div class="border border-gray-200 rounded-lg mt-4">
            <!-- Filters Section -->
            <div class="bg-white p-3 flex justify-between rounded-lg flex-wrap gap-4">
                <div class="relative  w-[50%] rounded-lg">
                    <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                        <span class="text-gray-500">
                            <img src="<?php echo e(asset('assets/search.png')); ?>" alt="icon" />
                        </span>
                        <input type="text" name="search_query" id="search" placeholder="Search Staff..."
                            onkeyup="fetchStaffData()"
                            class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                    </div>
                </div>
                <div class="flex gap-x-2 items-center">

                </div>
            </div>
            <div class="relative">

                <span id="staff-members">
                    <?php echo $__env->make('staff.staffSearch', [
                        'staff' => $staff,
                    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </span>

                <?php echo e($staff->links('vendor.pagination.custom-pagination')); ?>


            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function toggleDropdown(button) {
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            button.nextElementSibling.classList.toggle("hidden");
        }

        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });

        function fetchStaffData() {
            let search = document.getElementById("search").value;

            $.ajax({
                url: "<?php echo e(route('staff')); ?>",
                method: "GET",
                data: {
                    search_query: search,
                },
                success: function(response) {
                    $('#staff-members').html(response);
                }
            });
        }

        function updateStatus(staffId, el) {
            if (!confirm('Are you sure you want to update the status?')) return;
            $.ajax({
                url: '<?php echo e(url('/staff/update-status')); ?>/' + staffId,
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    // Find the status cell in the same row and update its text
                    var row = $(el).closest('tr');
                    var statusCell = row.find('td').eq(3);
                    if (response.status === 'active') {
                        statusCell.html('Active');
                    } else {
                        statusCell.html(
                            '<span class="bg-[#FEF9C3] text-[#854D0E] px-2 py-1 rounded-2xl text-sm">Resigned</span>'
                        );
                    }
                },
                error: function() {
                    alert('Failed to update status.');
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/staff/staff.blade.php ENDPATH**/ ?>