<?php $__env->startSection('content'); ?>
    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline"><?php echo e(session('error')); ?></span>
        </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button onclick="window.location.href='<?php echo e(route('show.attendance')); ?>'"
                    class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Student Attendance
                </button>
                <button onclick="window.location.href='<?php echo e(route('attendance.report')); ?>'"
                    class="tab-btn pb-3 text-gray-700 font-semibold">
                    Attendance Report
                </button>
            </div>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4 overflow-x-auto pb-2">
    <!-- Total Students -->
    <div class="flex items-center p-4 border border-[#E5E7EB] rounded-lg shadow-sm bg-white min-w-[220px]">
        <div class="w-12 h-12 flex items-center justify-center bg-[#DBEAFE] text-white rounded-xl">
            <i class="fas fa-users text-xl text-[#1B9AF5]"></i>
        </div>
        <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#6B7280]">Total Students</h4>
            <p class="text-gray-700 text-xl font-bold"><?php echo e($totalActiveStudents); ?></p>
        </div>
    </div>

    <!-- Present -->
    <div class="flex items-center p-4 border border-[#BBF7D0] rounded-lg shadow-sm bg-[#f0fdf4] min-w-[220px]">
        <div class="w-12 h-12 flex items-center justify-center bg-[#DCFCE7] text-[#16A34A] rounded-xl">
            <i class="fa-solid fa-check text-xl"></i>
        </div>
        <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#16A34A]">Present</h4>
            <p class="text-gray-700 text-xl font-bold"><?php echo e($presentCount); ?></p>
        </div>
    </div>

    <!-- Half Day Leave -->
 <div class="flex items-center p-4 border border-[#C7D2FE] rounded-lg shadow-sm bg-[#EEF2FF]">
    <div class="w-12 h-12 flex items-center justify-center bg-[#E0E7FF] text-[#4F46E5] rounded-xl">
        <i class="fa-solid fa-clock-rotate-left text-xl"></i> <!-- Different icon -->
    </div>
    <div class="ml-4">
        <h4 class="text-sm font-semibold text-[#4F46E5]">Half Day Leave</h4>
        <p class="text-gray-700 text-xl font-bold"><?php echo e($halfDayLeaveCount); ?></p>
    </div>
</div>


    <!-- Absent -->
    <div class="flex items-center p-4 border border-[#FECACA] rounded-lg shadow-sm bg-[#fef2f2] min-w-[220px]">
        <div class="w-12 h-12 flex items-center justify-center bg-[#FEE2E2] text-[#DC2626] rounded-xl">
            <i class="fa-solid fa-xmark text-xl"></i>
        </div>
        <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#DC2626]">Absent</h4>
            <p class="text-gray-700 text-xl font-bold"><?php echo e($absentCount); ?></p>
        </div>
    </div>

    

    <!-- On Leave -->
    <div class="flex items-center p-4 border border-[#FEF08A] rounded-lg shadow-sm bg-[#fefbe8] min-w-[220px]">
        <div class="w-12 h-12 flex items-center justify-center bg-[#FEF9C3] text-[#CA8A04] rounded-xl">
            <i class="fa-solid fa-right-from-bracket text-xl"></i>
        </div>
        <div class="ml-4">
            <h4 class="text-sm font-semibold text-[#CA8A04]">On Leave</h4>
            <p class="text-gray-700 text-xl font-bold"><?php echo e($onLeaveCount); ?></p>
        </div>
    </div>
</div>

        <div class="bg-white my-8 rounded-lg">
            <form method="GET" action="<?php echo e(route('show.attendance')); ?>">
                <div class="flex p-3 justify-between items-center gap-4">
                    <div class="relative w-[40%] rounded-lg">
                        <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                            <span class="text-gray-500">
                                <img src="<?php echo e(asset('assets/search.png')); ?>" alt="icon" />
                            </span>
                            <input type="text" name="search" id="search-input" value="<?php echo e(request('search')); ?>"
                                placeholder="Search Student..."
                                class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                        </div>
                    </div>

                    <div class="flex gap-x-2 items-center">
                        <select required name="class_id" class="border p-2 min-w-[100px] rounded-lg">
                            <option value="">Select Class</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->id); ?>"
                                    <?php echo e(request('class_id') == $class->id ? 'selected' : ''); ?>>
                                    <?php echo e($class->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <select required name="section_id" class="border p-2 min-w-[100px] rounded-lg">
                            <option value="">Select Section</option>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"
                                    <?php echo e(request('section_id') == $section->id ? 'selected' : ''); ?>>
                                    Section <?php echo e($section->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <input type="date" name="date" value="<?php echo e(request('date')); ?>"
                            class="border p-2 rounded-lg min-w-[130px] text-gray-600" />

                        <button type="submit"
                            class="bg-[#0197FF] text-white min-w-[80px] text-md rounded-lg px-2 py-2 text-nowrap">
                            Apply
                        </button>
                    </div>
                </div>
            </form>
            <div class="mt-4 relative">
                <table class="w-full bg-white border-gray-300  ">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-left text-gray-800 font-medium">


                            <th class="p-3 text-gray    -800 font-medium">Student Detail</th>
                            <th class="p-3 text-gray-800 font-medium">
                                Student Name
                            </th>

                            <th class="p-3 text-gray-800 font-medium">Attendance</th>
                            <th class="p-3 text-gray-800 font-medium">Remarks</th>
                            <th class="p-3 text-gray-800 font-medium"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <form method="POST" action="<?php echo e(route('submit.attendance')); ?>">
                            <?php echo csrf_field(); ?>

                            <!-- Row 1 -->
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b">

                                    <td class="p-3"> Class-<?php echo e($student->classes->first()->name); ?> |
                                        Section-<?php echo e($student->sections->first()->name); ?> | Roll NO:
                                        <?php echo e($student->latestAdmission->roll_number); ?></td>
                                    <td class="p-3 flex items-center space-x-3">
                                        <img src="<?php echo e($student->documents && $student->documents->photo ? asset('storage/' . $student->documents->photo) : asset('assets/sidebar/student.png')); ?>"
                                            alt="Student" class="w-10 h-10 rounded-full" />

                                        <p class="font-medium"><?php echo e($student->student_name); ?></p>
                                    </td>
                                    <td class="p-3">
                                        <div class="flex flex-wrap gap-x-4">
                                            <?php $__currentLoopData = ['Present', 'Absent', 'Leave', 'Half Day']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <label class="flex text-gray-700 items-center space-x-1">
                                                    <input type="radio" name="attendance[<?php echo e($student->id); ?>]"
                                                        value="<?php echo e($status); ?>" class="w-4 h-4"
                                                        <?php echo e(isset($attendances[$student->id]) && strtolower(str_replace(' ', '_', $attendances[$student->id]->status)) === strtolower(str_replace(' ', '_', $status)) ? 'checked' : ($status === 'Present' ? 'checked' : '')); ?> />
                                                    <span><?php echo e($status); ?></span>
                                                </label>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>




                                    </td>

                                    <td class="p-3">
                                        <input type="text" name="remarks[<?php echo e($student->id); ?>]"
                                            class="w-full p-2 border rounded" placeholder="Add remarks"
                                            value="<?php echo e(isset($attendances[$student->id]) ? $attendances[$student->id]->remarks : ''); ?>" />
                                    </td>


                                    <td class="p-3 text-center relative">
                                        <!-- <div class="flex gap-x-5 items-center"> -->
                                        <button onclick="event.preventDefault();toggleDropdown(this)" class="action-btn">
                                            <img src="<?php echo e(asset('assets/actions.png')); ?>" alt="icons" />
                                        </button>
                                        <!-- </div> -->
                                        <div
                                            class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                                            <a href="<?php echo e(route('attendance.show', $student->id)); ?>"
                                                class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Attendance
                                                History</a>
                                            <!-- <a href="#" class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Struck off</a> -->
                                            <a href="<?php echo e(route('student.profile', $student->id)); ?>"
                                                class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">View
                                                Profile</a>
                                        </div>
                                    </td>
                                </tr>
                                <!-- Hidden inputs to pass class_id and section_id -->
                                <input type="hidden" name="class_id[<?php echo e($student->id); ?>]"
                                    value="<?php echo e($student->latestAdmission->class_id); ?>">
                                <input type="hidden" name="section_id[<?php echo e($student->id); ?>]"
                                    value="<?php echo e($student->latestAdmission->section_id); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                </table>
                <div class="flex bg-white border-t border-gray-200 justify-between items-center p-4">
                    <div></div> <!-- Empty left side -->

                    <div class="flex space-x-2">

                        <input type="submit" name="submit" value="Submit Attendance"
                            class="bg-[#0197FF] text-white min-w-[80px] text-md rounded-lg px-2 py-2 text-nowrap mt-4 cursor-pointer" />
                    </div>
                </div>
                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/stdAttendance/allStdAttend.blade.php ENDPATH**/ ?>