<?php $__env->startSection('content'); ?>
    <!-- Include Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <div class="bg-[#f9fafc] px-6 rounded">
        <h1 class="text-3xl font-bold mb-3">Student Ledger</h1>
        <!-- Search Section -->
        <form method="GET" action="<?php echo e(route('student.ledger.get')); ?>">
            <div class="flex bg-white px-4 rounded shadow-sm py-4 flex-wrap gap-4 items-end mb-6">

                <!-- Registration Number -->
                <div class="flex-1 items-center mt-4 space-x-4">
                    <label class="block mb-1 font-medium text-gray-700">Select Student</label>
                    <select id="head_code" name="head_code" class="border p-2 rounded-lg select2 custom-select2 w-full">
                        <option value="">Select </option>
                        <?php $__currentLoopData = $stdList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($s->head_code); ?>"
                                <?php echo e(request('head_code') == $s->head_code ? 'selected' : ''); ?>>
                                <?php echo e($s->student_name); ?> - <?php echo e($s->reg_no); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="flex-1 min-w-[200px]">
                    <label class="block text-gray-700 font-medium mb-1">Start Date</label>
                    <div class="relative">
                        <span class="absolute left-3 top-2.5 text-gray-400">
                            <i class="fas fa-calendar-alt"></i>
                        </span>
                        <input type="date" name="start_date" id="start_date"
                            class="w-full border rounded pl-10 pr-3 py-2 focus:outline-none"
                            value="<?php echo e(old('start_date', $startDate ?? '')); ?>" required />
                    </div>
                    <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-red-500 text-sm mt-1"><?php echo e('Required'); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- End Date -->
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-gray-700 font-medium mb-1">End Date</label>
                    <div class="relative">
                        <span class="absolute left-3 top-2.5 text-gray-400">
                            <i class="fas fa-calendar-check"></i>
                        </span>
                        <input type="date" name="end_date" id="end_date"
                            class="w-full border rounded pl-10 pr-3 py-2 focus:outline-none"
                            value="<?php echo e(old('end_date', $endDate ?? '')); ?>" required />
                    </div>
                    <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-red-500 text-sm mt-1"><?php echo e('Required'); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Search Button -->
                <div class="min-w-[200px]">
                    <button type="submit"
                        class="mt-6 w-full flex items-center justify-center gap-2 bg-[#1B9AF5] hover:bg-[#1787d1] text-white font-medium py-2.5 px-5 rounded-md">
                        <i class="fas fa-search"></i>
                        Search
                    </button>
                </div>
            </div>
        </form>

        <?php if(request('head_code') && request('start_date') && request('end_date')): ?>
            <a href="<?php echo e(route('pdf.student.ledger', [
                'head_code' => request('head_code'),
                'start_date' => request('start_date'),
                'end_date' => request('end_date'),
            ])); ?>"
                target="_blank" class="inline-block mb-4 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
                <i class="fas fa-file-pdf mr-2"></i> Download PDF
            </a>
        <?php endif; ?>

        <div class="flex text-[#4B5563] gap-6 p-4 bg-white shadow-sm rounded-md">
            <p>
                <span>Reg No:</span>
                <span class="font-semibold"><?php echo e($regNo ?? 'Null'); ?></span>
            </p>
            <p>
                <span>Student name:</span>
                <span class="font-semibold"><?php echo e($stdName ?? 'Null'); ?></span>
            </p>
            <p>
                <span>Father name:</span>
                <span class="font-semibold"><?php echo e($fthName ?? 'Null'); ?></span>
            </p>
            <p>
                <span>Father CNIC:</span>
                <span class="font-semibold"><?php echo e($fthCnic ?? 'Null'); ?></span>
            </p>
        </div>

        <!-- Table -->
        <div class="overflow-auto">
            <table class="w-full text-[#4B5563] table-auto text-sm text-left">
                <thead class="bg-[#f9fafc] text-[16px]">
                    <tr class="bg-white py-5">
                        <td class="px-4 py-4 border-b"></td>
                        <td class="px-4 py-4 border-b"></td>
                        <td class="px-4 py-4 border-b">Opening Balance</td>
                        <td class="px-4 py-4 border-b text-right" colspan="3"><?php echo e($stdOpenBalance ?? 0); ?></td>
                    </tr>
                    <tr>
                        <th class="px-4 py-4 border-b">Date</th>
                        <th class="px-4 py-4 border-b">Type</th>
                        <th class="px-4 py-4 border-b">Description</th>
                        <th class="px-4 py-4 border-b text-right">Debit</th>
                        <th class="px-4 py-4 border-b text-right">Credit</th>
                        <th class="px-4 py-4 border-b text-right">Total</th>
                    </tr>
                </thead>
                <tbody class="mt-3 text-[16px] border rounded-xl">
                    <?php
                        $totalDebit = 0;
                        $totalCredit = 0;
                        $runningBalance = $stdOpenBalance ?? 0;
                    ?>

                    <?php if($stdLedger->isNotEmpty()): ?>
                        <?php $__currentLoopData = $stdLedger; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $totalDebit += $item->debit;
                                $totalCredit += $item->credit;
                                $runningBalance += $item->debit - $item->credit;
                            ?>
                            <tr class="bg-white py-5">
                                <td class="px-4 py-4 border-b">
                                    <?php echo e(\Carbon\Carbon::parse($item->created_at)->format('Y-m-d')); ?></td>
                                <td class="px-4 py-4 border-b"><?php echo e($item->transaction_type ?? '-'); ?></td>
                                <td class="px-4 py-4 border-b"><?php echo e($item->remarks ?? '-'); ?></td>
                                <td class="px-4 py-4 border-b text-right">
                                    <?php echo e($item->debit > 0 ? number_format($item->debit, 2) : ''); ?>

                                </td>
                                <td class="px-4 py-4 border-b text-right">
                                    <?php echo e($item->credit > 0 ? number_format($item->credit, 2) : ''); ?>

                                </td>
                                <td class="px-4 py-4 border-b text-right">
                                    <?php echo e(number_format($runningBalance, 2)); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr class="bg-white py-5">
                            <td class="px-4 py-4 border-b text-center" colspan="6">No record found.</td>
                        </tr>
                    <?php endif; ?>

                    <tr class="py-5">
                        <td class="px-4 py-4 border-b" colspan="3">
                            <div>
                                <p class="bg-[#f9fafc] font-semibold mt-1">Total</p>
                            </div>
                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            <?php echo e(number_format($totalDebit, 2)); ?>

                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            <?php echo e(number_format($totalCredit, 2)); ?>

                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            <?php echo e(number_format($stdOpenBalance + $totalDebit - $totalCredit, 2)); ?>

                        </td>
                    </tr>

                </tbody>
            </table>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('.select2').select2({
                allowClear: true,
                width: '100%'
            });
            $(document).on('select2:open', function() {
                const searchField = $('.select2-search__field');
                if (searchField.length) {
                    searchField[0].focus();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('schoolLayout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xamp\htdocs\REMS\resources\views/student/stdledger.blade.php ENDPATH**/ ?>