<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\AcademicController;
use App\Http\Controllers\StaffMemberController;
use App\Http\Controllers\NewStudentApplicationController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\DashboardController;



Route::get('/', function () {
    return view('home');
})->name('home');
Route::get('/logins', function(){
    return view('sign-in');
})->name('sign.in');


// HR section add new member 
Route::get('/staff-members', [StaffMemberController::class, 'staff_members'])->name('staff-members');
Route::get('/past-staff-members', [StaffMemberController::class, 'past_staff_members'])->name('past_staff-members');

Route::get('/staff-members/create', [StaffMemberController::class, 'create'])->name('staff-members.create');
Route::post('/staff-members', [StaffMemberController::class, 'store_staff_member'])->name('staff_members_store');
// hr section job application route 

// Route to display the job application form
Route::get('/job-position',[StaffMemberController::class,'job_positions'])->name('job-positions');
Route::get('/job-position/create',[StaffMemberController::class,'job_positions_create'])->name('job-positions-create');
Route::post('/job-position/store',[StaffMemberController::class,'job_positions_store'])->name('job-positions-store');

Route::get('/job_position_edit/{job}', [StaffMemberController::class, 'job_position_edit'])->name('job_position.update');

Route::get('/job_position_delete/{id}', [StaffMemberController::class, 'job_position_delete'])->name('job_position.delete');


Route::get('/job-application/{id?}', [StaffMemberController::class, 'job_application'])
    ->name('job_application');

Route::get('/job-application/create', [StaffMemberController::class, 'job_application_create'])
    ->name('job_application_create');

// Route to handle the form submission and store the data
Route::post('/job-application/store', [StaffMemberController::class, 'job_application_store'])
    ->name('job_application_store');

// job application approve , rejected , Pending 
Route::get('/job-application/{id}/status/{status}', [StaffMemberController::class, 'job_application_status'])->name('job_application_status');




// Academics section
Route::get('/academic/classes',[AcademicController::class,'show_classes'])->name('classes');
Route::post('/academic/classes',[AcademicController::class,'store_class'])->name('store.class');
Route::put('/classes/update/{id}',[AcademicController::class,'update_class'])->name('update.class');
Route::get('/classes/delete/{id}',[AcademicController::class,'delete_class'])->name('delete.class');

// Academic Sections  -->sessions 
Route::get('/account/school-sessions',[AcademicController::class,'school_sessions'])->name('school-sessions');
Route::get('/account/school-sessions/{id}',[AcademicController::class,'get_school_session_data'])->name('school-sessions.edit');
Route::put('/account/school-sessions-update',[AcademicController::class,'school_session_update'])->name('school-sessions.update');
Route::post('/account/school-sessions/create',[AcademicController::class,'school_sessions_store'])->name('school-sessions-store');
Route::get('/account/school-sessions-delete/{id}',[AcademicController::class,'school_session_delete'])->name('school.sessions.delete');

// sections 
Route::get('/academic/sections',[AcademicController::class,'show_sections'])->name('sections');
Route::post('/academic/sections',[AcademicController::class,'store_section'])->name('store.sections');
Route::put('/section/update/{id}',[AcademicController::class,'update_section'])->name('update.section');
Route::get('/section/delete/{id}',[AcademicController::class,'delete_section'])->name('delete.section');

// subjects
Route::get('/academic/subjects',[AcademicController::class,'show_subjects'])->name('subjects');
Route::post('/academic/subjects',[AcademicController::class,'store_subject'])->name('store.subjects');
Route::put('/subjects/update/{id}',[AcademicController::class,'update_subject'])->name('update.subject');
Route::get('/subjects/delete/{id}',[AcademicController::class,'delete_subject'])->name('delete.subject');

// teacher timetable
Route::get('/academic/teacher-timetable',[AcademicController::class,'teacher_timetable'])->name('teacher.timetable');
Route::post('/academic/teacher-timetable',[AcademicController::class,'store_teacher_timetable'])->name('store.teacher.timetable');


// Dashboard (Only Admins)

// Authenticated Users (Profile Management)
Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class,'latestStudents'])->middleware(['auth', 'verified', 'role:admin,user'])->name('dashboard');

    /* Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy'); */
});

// Admin Page (Only Admins)
Route::get('/admin', function () {
    return 'Admin Page';
})->middleware('role:admin');
// Dashboard route
/* Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard'); 
 */
// School Management System Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/schools', function () {
        return 'Manage Schools';
    })->middleware('role:super_admin,school_admin')->name('schools.index');
    Route::get('/schools/create', function () {
        return 'Create School';
    })->middleware('role:super_admin,school_admin')->name('schools.create');
    Route::get('/school/settings', function () {
        return 'School Settings';
    })->middleware('role:school_admin')->name('school.settings');

    Route::get('/teachers', function () {
        return 'Manage Teachers';
    })->middleware('role:school_admin')->name('teachers.index');
    Route::get('/students', function () {
        return 'Manage Students';
    })->middleware('role:school_admin,teacher')->name('students.index');
    Route::get('/parents', function () {
        return 'Manage Parents';
    })->middleware('role:school_admin')->name('parents.index');

    Route::get('/classes', function () {
        return 'Manage Classes';
    })->middleware('role:school_admin,teacher')->name('classes.index');
    Route::get('/timetable', function () {
        return 'View Timetable';
    })->middleware('role:student,teacher,parent')->name('timetable.index');

    Route::get('/attendance', function () {
        return 'View Attendance';
    })->middleware('role:teacher,student,parent')->name('attendance.index');
    Route::get('/grades', function () {
        return 'View Grades';
    })->middleware('role:teacher,student,parent')->name('grades.index');
});

//Student Routes
Route::get('student-applications', [NewStudentApplicationController::class, 'index'])->name('student.application');
Route::get('/new-student-application', function () {
    return view('school.student.all-applictions.new-student-application');
})->name('student.application.form');

Route::post('/submit-application', [NewStudentApplicationController::class, 'store'])->name('submit.application');
Route::get('/student/admission', [StudentController::class, 'show_form'])->name('student.admission');
Route::post('/student/register', [StudentController::class, 'store'])->name('student.register');
Route::get('/student/current-student', [StudentController::class, 'currentStudent'])->name('student.currentStudent');

Route::post('/student/mark-alumini', [StudentController::class, 'mark_alumni'])->name('mark.as.alumni');
Route::get('/student/mark-alumini-single/{id}', [StudentController::class, 'mark_alumni_single'])->name('mark.as.alumni.single');

Route::get('/student/current-student-grid', [StudentController::class, 'currentStudentGrid'])->name('student.currentStudentGrid');
Route::get('/student/student-alumni', [StudentController::class, 'studentAlumni'])->name('student.studentAlumni');
Route::get('/student/admission-letters', [StudentController::class, 'admission_letters'])->name('student.admissionLetters');
Route::get('/student/reports-screens', [StudentController::class, 'reports_screens'])->name('student.reportsScreens');

Route::get('/student/card-customization/{template_name}', [StudentController::class, 'card_customize'])->name('student.card-customize');

Route::post('/student/card-customization/store/{template_name}', [StudentController::class, 'store_card_customize'])->name('student.card-customize.store');

Route::get('/student/profile/{id}', [StudentController::class, 'student_profile'])->name('student.profile');
Route::get('/student/edit/{id}', [StudentController::class, 'student_edit'])->name('student.edit');
Route::post('/student/update/{id}', [StudentController::class, 'student_update'])->name('student.update');

//*****Account section ***************/

Route::get('/account/fee-structure',[AccountController::class,'show_fee_structure'])->name('show.fee.structure');
Route::get('/account/fee-management',[AccountController::class,'show_fee_management'])->name('show.fee.management');
Route::post('/account/store-fee-structure',[AccountController::class,'store_fee_structure'])->name('store.fee.structure');

Route::get('/fee-structure', [AccountController::class, 'fetch_fee_structure'])->name('fetch-fee-structure');
Route::post('/fee-structure/stgenerate-student-fee', [AccountController::class, 'generate_student_fee'])->name('generate-fee-structure');
Route::get('/fee-structure/{classId}/edit', [AccountController::class, 'edit_fee_structure'])->name('fee-structure.edit');
Route::post('/fee-structure/update', [AccountController::class, 'update_fee_structure'])->name('update.fee.structure');

Route::get('/fee-recipt-form/{reg?}',[AccountController::class, 'fee_recipt_form'])->name('fee_recipt_form');


// search Student
Route::get('/search-students/{reg}', [AccountController::class, 'searchStudents'])
    ->name('search.students');
    //expense section
Route::get('/account/expenses',[AccountController::class,'show_expenses'])->name('show.expenses');
Route::get('/account/expenses-add',[AccountController::class,'add_expenses'])->name('add.expenses');
Route::post('/account/expenses-store',[AccountController::class,'store_expenses'])->name('expenses.store');
Route::put('/account/expenses-update/{id}',[AccountController::class,'update_expense'])->name('expenses.update');
Route::get('/account/expenses-delete/{id}',[AccountController::class,'delete_expense'])->name('expenses.delete');


Route::get('/account/expense-categories',[AccountController::class,'show_expense_categories'])->name('show.expense.categories');
Route::post('/account/expense-categories-store',[AccountController::class,'expense_categories_store'])->name('expense.categories.store');

Route::put('/account/expense-categories-update/{id}',[AccountController::class,'expense_categories_update'])->name('expense.categories.update');

Route::get('/account/expense-categories-delete/{id}',[AccountController::class,'expense_categories_delete'])->name('expense.categories.delete');


//settings
Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
Route::post('/settings/update', [SettingsController::class, 'update'])->name('settings.update');
Route::get('/settings/role-permissions',[SettingsController::class,'role_permissions'])->name('settings.role-permissions');
Route::put('/settings/update-role-permissions', [SettingsController::class, 'updateRolePermissions'])->name('settings.update-role-permissions');
Route::post('/settings/create-role', [SettingsController::class, 'store_role'])->name('settings.create-role');

require __DIR__ . '/auth.php';
