<?php
use App\Http\Controllers\DatabaseController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\AttendanceApiController;

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

Route::post('/login', function (Request $request) {
    $credentials = $request->only('email', 'password');

    if (!$token = Auth::guard('api')->attempt($credentials)) {
        return response()->json(['error' => 'Unauthorized'], 401);
    }

    return response()->json([
        'access_token' => $token,
        'token_type' => 'bearer',
        'expires_in' => auth('api')->factory()->getTTL() * 60
    ]);
});
 
Route::middleware('auth:api')->get('/attendance/today', [AttendanceApiController::class, 'getTodayAttendance']);
Route::middleware('auth:api')->get('/students/{class_id}', [AttendanceApiController::class, 'getStudentsByClass']);
Route::middleware('auth:api')->get('/classes', [AttendanceApiController::class, 'getAllClasses']);
Route::middleware('auth:api')->get('/staff', [AttendanceApiController::class, 'getStaff']);
Route::middleware('auth:api')->get('/all', [AttendanceApiController::class, 'getAll']);

?>