@if ($paginator->hasPages())
    <nav role="navigation" aria-label="Pagination Navigation" class="mt-6 px-4">
        <!-- Showing X to Y of Z results -->
        <div class="flex justify-between items-center mb-4">
            <p class="text-sm text-gray-700">
                Showing
                <span class="font-medium">{{ $paginator->firstItem() }}</span>
                to
                <span class="font-medium">{{ $paginator->lastItem() }}</span>
                of
                <span class="font-medium">{{ $paginator->total() }}</span>
                results
            </p>

            <!-- Pagination Links -->
            <div class="flex gap-2">
                <!-- Previous Button -->
                @if ($paginator->onFirstPage())
                    <span class="px-3 py-1 border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed">
                        Previous
                    </span>
                @else
                    <a href="{{ $paginator->previousPageUrl() }}" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                        Previous
                    </a>
                @endif

                <!-- Page Numbers -->
                @foreach ($paginator->getUrlRange(1, $paginator->lastPage()) as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <span class="px-3 py-1 border border-gray-300 bg-blue-700 text-white rounded-lg">
                            {{ $page }}
                        </span>
                    @else
                        <a href="{{ $url }}" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                            {{ $page }}
                        </a>
                    @endif
                @endforeach

                <!-- Next Button -->
                @if ($paginator->hasMorePages())
                    <a href="{{ $paginator->nextPageUrl() }}" class="px-3 py-1 border border-gray-300 rounded-lg hover:bg-gray-100">
                        Next
                    </a>
                @else
                    <span class="px-3 py-1 border border-gray-300 rounded-lg text-gray-400 cursor-not-allowed">
                        Next
                    </span>
                @endif
            </div>
        </div>
    </nav>
@endif