@extends('schoolLayout.app')

@section('content')
    @if (session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-600 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-[50%]">
                {{--  <button class="tab-btn pb-3 text-gray-700 font-semibold">
                    Class Timetable
                </button> --}}
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Teacher Timetable
                </button>
            </div>

            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-2 text-white rounded-lg" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Assign New Class</span>
            </button>
        </div>

        <div class="border border-gray-200 rounded-lg mt-4">
            <!-- Filters Section -->
            <div class="bg-white p-3 flex items-center justify-between rounded-lg flex-wrap gap-4">
                <h1 class="text-2xl font-semibold">Teacher Timetable Management</h1>
                <form action="{{ route('teacher.timetable.pdf') }}" method="GET" class="flex items-center gap-x-4">
                    <div class="flex flex-col">
                        <label for="teacher_id" class="text-sm font-semibold mb-1">Select Teacher</label>
                        <select name="teacher_id" id="teacherFilterDropdown" class="border p-2 rounded-lg w-full">
                            <option value="">All Teachers</option>
                            @foreach ($teachers as $teacher)
                                <option value="{{ $teacher->id }}"
                                    {{ request('teacher_id') == $teacher->id ? 'selected' : '' }}>
                                    {{ $teacher->full_name }}
                                </option>
                            @endforeach
                        </select>

                    </div>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded-lg hover:bg-blue-600">
                        <i class="fa-solid fa-file-pdf"></i> Download PDF
                    </button>
                </form>

            </div>

            <!-- Timetable List -->
            <div class="relative bg-white">
                @foreach ($timetables as $timetable)
                    @if ($timetable->teacher_timetables->isEmpty())
                        @continue
                    @endif

                    <div class="timetable-block" data-teacher-id="{{ $timetable->id }}">
                        <table class="w-full border-collapse mb-6">
                            <thead class="bg-[#f9fafc]">
                                <tr class="text-gray-600">
                                    <th class="p-3 text-left font-medium text-gray-500">Teacher</th>
                                    @foreach ($timetable->teacher_timetables as $time)
                                        <th class="p-3 text-left font-medium text-gray-500">
                                            {{ $time->start_time }} - {{ $time->end_time }}
                                        </th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody class="bg-white py-3 rounded-lg">
                                <tr class="border-b">
                                    <td class="p-3 text-gray-600">{{ $timetable->full_name }}</td>
                                    @foreach ($timetable->teacher_timetables as $time)
                                        <td class="p-3 text-gray-600">
                                            <div>
                                                <h3 class="font-semibold text-black">Subject - {{ $time->subjects->name }}
                                                </h3>
                                                <p class="text-gray-500">Class - {{ $time->classes->name }}</p>
                                                <p class="text-gray-500">Section - {{ $time->sections->name }}</p>
                                            </div>
                                        </td>
                                    @endforeach
                                </tr>
                            </tbody>
                        </table>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Modal for Assigning New Class -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-lg rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Assign New Class</h2>
                <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
            <form action="{{ route('store.teacher.timetable') }}" method="POST">
                @csrf
                <div class="bg-white px-6 py-3">
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">Teacher Name <span
                                class="text-red-500">*</span></label>
                        <select class="w-full px-3 py-2 border rounded-md text-gray-700" name="teacher_id">
                            @foreach ($teachers as $index => $teacher)
                                <option value="{{ $teacher->id }}" @if ($index == 0) selected @endif>
                                    {{ $teacher->full_name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">Class <span
                                class="text-red-500">*</span></label>
                        <select class="w-full px-3 py-2 border rounded-md" name="class_id">
                            @foreach ($classes as $index => $class)
                                <option value="{{ $class->id }}" @if ($index == 0) selected @endif>
                                    {{ $class->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">Section <span
                                class="text-red-500">*</span></label>
                        <select class="w-full px-3 py-2 border rounded-md" name="section_id">
                            @foreach ($sections as $index => $section)
                                <option value="{{ $section->id }}" @if ($index == 0) selected @endif>
                                    {{ $section->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-1">Subject <span
                                class="text-red-500">*</span></label>
                        <select class="w-full px-3 py-2 border rounded-md" name="subject_id">
                            @foreach ($subjects as $index => $subject)
                                <option value="{{ $subject->id }}" @if ($index == 0) selected @endif>
                                    {{ $subject->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4 flex gap-4">
                        <div class="w-1/2">
                            <label class="block text-gray-700 font-semibold mb-1">Start Time <span
                                    class="text-red-500">*</span></label>
                            <input type="time" class="w-full px-3 py-2 border rounded-md" name="start_time" />
                        </div>
                        <div class="w-1/2">
                            <label class="block text-gray-700 font-semibold mb-1">End Time <span
                                    class="text-red-500">*</span></label>
                            <input type="time" class="w-full px-3 py-2 border rounded-md" name="end_time" />
                        </div>
                    </div>
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button id="closeModalBtn" type="button"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Save Assignment
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- JS Scripts -->
    <script>
        // Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });

        document.getElementById("teacherFilterDropdown").addEventListener("change", function() {
            const selectedId = this.value;
            const blocks = document.querySelectorAll(".timetable-block");

            blocks.forEach(block => {
                const teacherId = block.getAttribute("data-teacher-id");
                if (!selectedId || teacherId === selectedId) {
                    block.style.display = "block";
                } else {
                    block.style.display = "none";
                }
            });
        });
    </script>
@endsection
