@extends('schoolLayout.app')

@section('content')
    <div class="w-full mx-auto bg-[#f9fafc] mt-10 bg-white p-8 rounded-lg shadow-md">
        <h2 class="text-2xl mb-6">Edit Student Admission Form</h2>

        <form action="{{ route('student.update', $student->id) }}" method="POST" enctype="multipart/form-data">
            @csrf

            @if (session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                    <strong class="font-bold">Error:</strong>
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif

            @if (session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4"
                    role="alert">
                    <strong class="font-bold">Success:</strong>
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif
            <!-- Student Details -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-1">Session From<span class="text-red-600">*</span></label>
                    <input type="text" name="session_start"
                        class="w-full p-2 border rounded @error('session_start') border-red-500 @enderror"
                        value="{{ old('session_start', date('Y', strtotime('-1 year'))) }}">
                    @error('session_start')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block mb-1">Session To<span class="text-red-600"></span></label>
                    <input type="text" name="session_end"
                        class="w-full p-2 border rounded @error('session_end') border-red-500 @enderror"
                        value="{{ old('session_end', date('Y')) }}">
                    @error('session_end')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block mb-1">Student Name <span class="text-red-600">*</span></label>
                    <input type="text" value="{{ $student->student_name ?? 'N/A' }}" name="student_name"
                        class="w-full p-2 border rounded @error('student_name') border-red-500 @enderror"
                        value="{{ old('student_name', $student->student_name) }}">
                    @error('student_name')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Father's Name <span class="text-red-600">*</span></label>
                    <input type="text" name="father_name"
                        class="w-full p-2 border rounded @error('father_name') border-red-500 @enderror"
                        value="{{ old('father_name', $student->father_name  ?? 'N/A') }}">
                    @error('father_name')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Father CNIC <span class="text-red-600">*</span></label>
                    <input type="text" name="father_cnic"
                        class="w-full p-2 border rounded @error('father_cnic') border-red-500 @enderror"
                        value="{{ old('father_cnic', $student->father_cnic  ?? 'N/A') }}">
                    @error('father_cnic')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Email <span class="text-red-600">*</span></label>
                    <input type="email" name="email"
                        class="w-full p-2 border rounded @error('email') border-red-500 @enderror"
                        value="{{ old('email', $student->email  ?? 'N/A') }}">
                    @error('email')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Religion</label>
                    <select name="religion" class="w-full p-2 border rounded">
                        <option value="Islam" {{ old('religion', $student->religion  ?? 'N/A') == 'Islam' ? 'selected' : '' }}>Islam
                        </option>
                        <option value="Christianity"
                            {{ old('religion', $student->religion  ?? 'N/A') == 'Christianity' ? 'selected' : '' }}>Christianity
                        </option>
                        <option value="Hinduism" {{ old('religion', $student->religion  ?? 'N/A') == 'Hinduism' ? 'selected' : '' }}>
                            Hinduism</option>
                        <option value="Other" {{ old('religion', $student->religion  ?? 'N/A') == 'Other' ? 'selected' : '' }}>Other
                        </option>
                    </select>

                    @error('religion')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Mother's Name</label>
                    <input type="text" name="mother_name" class="w-full p-2 border rounded"
                        value="{{ old('mother_name', $student->mother_name  ?? 'N/A') }}" />

                    @error('mother_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Gender <span class="text-red-600">*</span></label>
                    <select name="gender" class="w-full p-2 border rounded @error('gender') border-red-500 @enderror">
                        <option value="Male" {{ old('gender', $student->gender  ?? 'N/A') == 'Male' ? 'selected' : '' }}>Male
                        </option>
                        <option value="Female" {{ old('gender', $student->gender  ?? 'N/A') == 'Female' ? 'selected' : '' }}>Female
                        </option>
                        <option value="Other" {{ old('gender', $student->gender  ?? 'N/A') == 'Other' ? 'selected' : '' }}>Other
                        </option>
                    </select>
                    @error('gender')
                        <p class="text-red-500 text-sm">{{ $message }}</p>
                    @enderror
                </div>
                <!-- Place of Birth -->
                <div class=" ">
                    <label class="block mb-1">Place of Birth</label>
                    <input type="text" name="place_of_birth" class="w-full p-2 border rounded"
                        value="{{ old('place_of_birth', $student->place_of_birth  ?? 'N/A') }}" />

                    @error('place_of_birth')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Date of Birth (Required) -->
                <div class=" ">
                    <label class="block mb-1">Date of Birth <span class="text-red-600">*</span></label>
                    <input type="date" name="date_of_birth" class="w-full p-2 border rounded"
                        value="{{ old('date_of_birth', $student->date_of_birth  ?? 'N/A') }}" />

                    @error('date_of_birth')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class Section -->
                <div>
                    <label class="block mb-1">Class</label>
                    <select name="class" class="w-full p-2 border rounded" id="class">
                        <option value="" disabled
                            {{ old('class', $student->latestAdmission->class_id  ?? 'N/A') == '' ? 'selected' : '' }}>Select Class
                        </option>
                        @foreach ($classes as $class)
                            <option value="{{ $class->id }}"
                                {{ old('class', $student->latestAdmission->class_id  ?? 'N/A') == $class->id ? 'selected' : '' }}>
                                {{ $class->name }}
                            </option>
                        @endforeach
                    </select>


                    @error('class')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class Section -->
                <div>
                    <label class="block mb-1">Class Section</label>
                    <select name="class_section" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('class_section', $student->latestAdmission->section_id  ?? 'N/A') == '' ? 'selected' : '' }}>Select
                            Section</option>
                        @foreach ($sections as $section)
                            <option value="{{ $section->id }}"
                                {{ old('class_section', $student->latestAdmission->section_id  ?? 'N/A') == $section->id ? 'selected' : '' }}>
                                Section {{ $section->name }}
                            </option>
                        @endforeach
                    </select>

                    @error('class_section')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- <div>
                <label class="block mb-1">Monthly Fee</label>
                <input type="text" name="monthly_fee" class="w-full p-2 border rounded" value="{{ old('monthly_fee') }}" />

                @error('guardian_contact')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
            </div> -->

            </div>

            <div class="grid grid-cols-2 gap-x-2">
                <!-- Permanent Address -->
                <div class="mt-4">
                    <label class="block mb-1">Permanent Address<span class="text-red-600">*</span></label>
                    <textarea name="permanent_address" class="w-full p-2 border rounded">{{ old('permanent_address', $student->permanent_address  ?? 'N/A') }}</textarea>

                    @error('permanent_address')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <!-- Current Address -->
                <div class="mt-4">
                    <label class="block mb-1">Current Address</label>
                    <textarea name="current_address" class="w-full p-2 border rounded">{{ old('current_address', $student->current_address  ?? 'N/A') }}</textarea>
                </div>
            </div>

            <!-- Guardian Details -->
            <h3 class="text-xl mt-6 mb-3 font-semibold">Guardian Details</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Guardian Name (Required) -->
                <div>
                    <label class="block mb-1">Guardian Name <span class="text-red-600">*</span></label>
                    <input type="text" name="guardian_name" class="w-full p-2 border rounded"
                        value="{{ old('guardian_name', $student->guardian->guardian_name ?? '') }}" />

                    @error('guardian_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Guardian Contact (Required) -->
                <div>
                    <label class="block mb-1">Guardian Contact <span class="text-red-600">*</span></label>
                    <input type="text" name="guardian_contact" class="w-full p-2 border rounded"
                        value="{{ old('guardian_contact', $student->guardian->guardian_contact ?? '') }}" />

                    @error('guardian_contact')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Student Relation with Guardian (Optional) -->
                <div>
                    <label class="block mb-1">Student Relation with Guardian</label>
                    <select name="guardian_relation" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == '' ? 'selected' : '' }}>
                            Select Relation</option>
                        <option value="Father"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Father' ? 'selected' : '' }}>
                            Father</option>
                        <option value="Mother"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Mother' ? 'selected' : '' }}>
                            Mother</option>
                        <option value="Brother"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Brother' ? 'selected' : '' }}>
                            Brother</option>
                        <option value="Sister"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Sister' ? 'selected' : '' }}>
                            Sister</option>
                        <option value="Uncle"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Uncle' ? 'selected' : '' }}>
                            Uncle</option>
                        <option value="Aunt"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Aunt' ? 'selected' : '' }}>
                            Aunt</option>
                        <option value="Grandfather"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Grandfather' ? 'selected' : '' }}>
                            Grandfather</option>
                        <option value="Grandmother"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Grandmother' ? 'selected' : '' }}>
                            Grandmother</option>
                        <option value="Other"
                            {{ old('guardian_relation', $student->guardian->relation_with_student ?? '') == 'Other' ? 'selected' : '' }}>
                            Other</option>
                    </select>

                    @error('guardian_relation')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Previous Education -->
            <!-- Toggle Button -->
            <div class="flex items-center space-x-3 mt-6 mb-3">
                <h3 class="text-xl font-semibold">Previous Education Details</h3>
                <button id="toggleBtn" type="button"
                    class="relative w-14 h-7 bg-gray-300 rounded-full transition-colors duration-300 focus:outline-none">
                    <span id="toggleCircle"
                        class="absolute left-1 top-1 w-5 h-5 bg-white rounded-full transition-transform duration-300"></span>
                </button>
            </div>

            <!-- Previous Education Fields -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 " id="previous-education">
                <!-- Previous School Name (Required) -->
                <div>
                    <label class="block mb-1">Previous School Name <span class="text-red-600">*</span></label>
                    <input type="text" name="previous_education[school_name]" class="w-full p-2 border rounded"
                    value="{{ old('previous_education.school_name', optional($student->previousEducation)->school_name ?? '') }}" />
                    @error('previous_education.school_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Last Class Passed (Required) -->
                <div>
                    <label class="block mb-1">Last Class Passed <span class="text-red-600">*</span></label>
                    <select name="previous_education[last_class_passed]" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('previous_education.last_class_passed',optional($student->previousEducation)->last_class_passed ?? '') == '' ? 'selected' : '' }}>
                            Select Last Class</option>
                        @foreach ($classes as $class)
                            <option value="{{ $class->id }}"
                                {{ old('previous_education.last_class_passed', optional($student->previousEducation)->last_class_passed) == $class->name ? 'selected' : '' }}>
                                {{ $class->name }}</option>
                        @endforeach

                    </select>
                    @error('previous_education.last_class_passed')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Class to Apply (Required) -->
                <div>
                    <label class="block mb-1">Class to Apply <span class="text-red-600">*</span></label>
                    <select name="previous_education[class_to_apply]" class="w-full p-2 border rounded">
                        <option value="" disabled
                            {{ old('previous_education.class_to_apply') == '' ? 'selected' : '' }}>Select Class</option>
                        @foreach ($classes as $class)
                            <option value="{{ $class->name }}"
                                {{ old('previous_education.class_to_apply', optional($student->previousEducation)->class_to_apply) == $class->name ? 'selected' : '' }}>
                                Class {{ $class->name }}</option>
                        @endforeach
                    </select>
                    @error('previous_education.class_to_apply')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>



                <!-- Last Result Grade/Percentage -->
                <div>
                    <label class="block mb-1">Last Result Grade/Percentage</label>
                    <input type="text" name="previous_education[last_result]" class="w-full p-2 border rounded"
                        value="{{ old('previous_education.last_result', optional($student->previousEducation)->last_result) }}" />
                    @error('previous_education.last_result')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Passing Year (Required) -->
                <div>
                    <label class="block mb-1">Passing Year <span class="text-red-600">*</span></label>
                    <input type="text" name="previous_education[passing_year]" class="w-full p-2 border rounded"
                        value="{{ old('previous_education.passing_year', optional($student->previousEducation)->passing_year) }}" />
                    @error('previous_education.passing_year')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>


            <!-- Emergency Contact -->
            <h3 class="text-xl font-semibold mt-6 mb-3">Emergency Contact</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-1">Emergency Contact Name<span class="text-red-600">*</span></label>
                    <input type="text" name="emergency_contact_name"
                        value="{{ old('emergency_contact_name', $student->emergencyContact->contact_name) }}"
                        class="w-full p-2 border rounded" />
                    @error('emergency_contact_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Emergency Contact Number<span class="text-red-600">*</span></label>
                    <input name="emergency_contact_number"
                        value="{{ old('emergency_contact_number', $student->emergencyContact->contact_number) }}"
                        type="text" class="w-full p-2 border rounded" />
                    @error('emergency_contact_number')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Relationship<span class="text-red-600">*</span></label>
                    <input name="relationship" value="{{ old('relationship', $student->emergencyContact->relationship) }}"
                        type="text" class="w-full p-2 border rounded" />
                    @error('relationship')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Medical Information -->
            <h3 class="text-xl font-semibold mb-3 mt-6">Medical Information</h3>
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block mb-1">Existing Medical Conditions</label>
                    <textarea name="medical_conditions" class="w-full p-2 border rounded h-20">{{ old('medical_conditions') }}</textarea>

                    @error('medical_conditions')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block mb-1">Blood Group</label>
                    <select name="blood_group" class="w-full p-2 border rounded">
                        <option value="" disabled {{ old('blood_group') == '' ? 'selected' : '' }}>Select Blood
                            Group</option>
                        <option value="A+" {{ old('blood_group', $student->blood_group) == 'A+' ? 'selected' : '' }}>A+
                        </option>
                        <option value="A-" {{ old('blood_group', $student->blood_group) == 'A-' ? 'selected' : '' }}>A-
                        </option>
                        <option value="B+" {{ old('blood_group', $student->blood_group) == 'B+' ? 'selected' : '' }}>B+
                        </option>
                        <option value="B-" {{ old('blood_group', $student->blood_group) == 'B-' ? 'selected' : '' }}>B-
                        </option>
                        <option value="O+" {{ old('blood_group', $student->blood_group) == 'O+' ? 'selected' : '' }}>O+
                        </option>
                        <option value="O-" {{ old('blood_group', $student->blood_group) == 'O-' ? 'selected' : '' }}>O-
                        </option>
                        <option value="AB+" {{ old('blood_group', $student->blood_group) == 'AB+' ? 'selected' : '' }}>
                            AB+</option>
                        <option value="AB-" {{ old('blood_group', $student->blood_group) == 'AB-' ? 'selected' : '' }}>
                            AB-</option>
                    </select>

                    @error('blood_group')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

            </div>

            <!-- Fee Assign -->
            <!--   <h3 class="text-xl font-semibold mt-6 mb-3 hidden" id="fee_assign_txt">Fee Assign</h3>
        <div id="fee_checkbox" class="flex flex-wrap gap-x-6 text-xl gap-y-8 ">

        </div>
    <h3 class="text-xl font-semibold mt-6 mb-3">Payments</h3>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">

        <div >
            <label name="discount" class="block mb-1">Total Amount</label>
            <span id="payable_amount" class="text-blue-700 font-semibold text-sm">0.00</span>
        </div>
        <div>
            <label name="discount" class="block mb-1">Discount</label>
            <input onkeyup="calculate_discounted(this.value)" type="number" id="discount" name="discount" class="w-full p-2 border rounded" value="{{ old('discount') }}" />
            @error('discount')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
        </div>

        <div>
            <label class="block mb-1">Total Paid</label>
            <input type="number" id="total_paid" name="total_paid" class="w-full p-2 border rounded" value="{{ old('total_paid') }}" />
            @error('total_paid')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
        </div>
       
    </div>   -->
            <!-- Document Uploads -->
            <!-- <h3 class="text-xl font-semibold mt-6 mb-3">Documents Required</h3>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
         <div>
            <label class="block mb-1">Student Photo</label>
            <label class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                <span class="text-sm text-gray-500 mt-2">
                    Drag and drop your photo here, or <span class="text-black">browse</span>
                </span>
                <span class="text-xs text-gray-400 mt-1">Supported formats: JPG, PNG (Max: 5MB)</span>
                <input type="file" name="student_photo" class="hidden" accept="image/png, image/jpeg" />
            </label>
            @error('student_photo')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
        </div>

         <div>
            <label class="block mb-1">Birth Certificate</label>
            <label class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                <span class="text-sm text-gray-500 mt-2">
                    Upload Birth Certificate, or <span class="text-black">browse</span>
                </span>
                <span class="text-xs text-gray-400 mt-1">Supported formats: PDF, JPG, PNG (Max: 10MB)</span>
                <input type="file" name="birth_certificate" class="hidden" accept="image/png, image/jpeg, application/pdf" />
            </label>
            @error('birth_certificate')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
        </div>

         <div>
            <label class="block mb-1">Previous School Leaving Certificate</label>
            <label class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                <span class="text-sm text-gray-500 mt-2">
                    Upload Leaving Certificate, or <span class="text-black">browse</span>
                </span>
                <span class="text-xs text-gray-400 mt-1">Supported formats: PDF, JPG, PNG (Max: 10MB)</span>
                <input type="file" name="leaving_certificate" class="hidden" accept="image/png, image/jpeg, application/pdf" />
            </label>
            @error('leaving_certificate')
        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
    @enderror
        </div>
    </div> -->


            <div class="flex justify-end gap-x-4 items-center">
                <div class="text-center mt-6">
                    <a class="border border-gray-400 text-black px-6 py-2 rounded-lg hover:bg-blue-700"
                        href="{{ route('student.currentStudent') }}">
                        Cancel
                    </a>
                </div>
                <div class="text-center mt-6">
                    <button type="submit" class="bg-[#0197FF] text-white px-6 py-2 rounded-lg hover:bg-blue-700">
                        Submit Application
                    </button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script>
        const toggleBtn = document.getElementById("toggleBtn");
        const toggleCircle = document.getElementById("toggleCircle");
        const previous_education = document.getElementById('previous-education');
        previous_education.classList.add('hidden')
        toggleBtn.addEventListener("click", () => {
            toggleBtn.classList.toggle("bg-green-500");
            toggleCircle.classList.toggle("translate-x-7");
            previous_education.classList.toggle('hidden');
        });

        const classSelect = document.getElementById('class');
        const feeCheckbox = document.getElementById('fee_checkbox');
        const feeStructures = @json($fee_structures);
        window.onload = () => {
            showCheckbox(feeStructures, classSelect.value);
        };
        classSelect.addEventListener('change', (e) => {
            showCheckbox(feeStructures, e.target.value);
        });

        function showCheckbox(feeStructures, classId) {
            let html = '';

            feeStructures.forEach(fee => {
                if (fee.class_id == classId) {
                    let formattedFeeType = formatFeeType(fee.fee_type); // Format the fee type
                    html += `
                <label class="flex items-center space-x-4">
                    <input type="checkbox" onclick="calculate(${fee.amount}, this)" name="fee_assign[]" value="${fee.id}" class="w-5 h-5 text-blue-600 border-gray-300 rounded">
                    <div class="text-md">
                    <p>${formattedFeeType}</p>
                    <p class="text-blue-700 font-semibold text-sm">${fee.amount}</label>
                    </div>
                </label>
            `;

                }
            });

            if (html) {
                document.getElementById('fee_assign_txt').classList.remove('hidden');
                feeCheckbox.innerHTML = html;
            } else {
                document.getElementById('fee_assign_txt').classList.add('hidden');
                feeCheckbox.innerHTML = '<p class="text-gray-500">No fee structures found for this class.</p>';
            }
        }

        // Function to format fee type (replace underscores and capitalize first word)
        function formatFeeType(feeType) {
            let words = feeType.replace(/_/g, ' ').split(' ');
            words[0] = words[0].charAt(0).toUpperCase() + words[0].slice(1);
            return words.join(' ');
        }

        let totalAmount = 0; // Initialize total amount

        function calculate(amount, checkbox) {
            let discount = document.getElementById("discount").value;
            if (checkbox.checked) {
                totalAmount += amount; // Add amount if checked
            } else {
                totalAmount -= amount; // Subtract amount if unchecked
            }
            totalAmount -= discount; // Subtract discount
            document.getElementById("payable_amount").innerText = totalAmount.toFixed(2); // Update div
            document.getElementById("total_paid").value = totalAmount.toFixed(2); // Update div
        }

        function calculate_discounted(discount) {
            let totalAmount = parseFloat(document.getElementById("payable_amount").innerText) || 0; // Convert to number
            let totalPaid = totalAmount - discount;
            document.getElementById("total_paid").value = totalPaid.toFixed(2); // Ensure two decimal places
        }
    </script>
@endsection
