<div
        class="p-6 w-full bg-white rounded-lg shadow-sm flex justify-between items-center"
      >
        <!-- Left Section: Profile Image + Student Info -->
        <div class="flex items-center gap-x-4">
          <img
          src="{{ $student->documents && $student->documents->photo ? url('/student-image/' . $student->documents->photo) : asset('assets/sidebar/student.png') }}"

            alt="Student Profile"
            class="w-28 h-28 rounded-full object-cover border"
          />
          
          <div>
            <h2 class="text-xl font-bold">{{ $student->student_name }}</h2>
            <p class="text-gray-500 mb-2">{{ $student->email }}</p>
            <p class="text-gray-500 mb-2">{{ $student->reg_no }}</p>
            <p class="text-gray-600">Class: {{ $student->classes->first()->name }} - Section {{ $student->sections->first()->name }}</p>
            <p class="text-gray-600">Contact: {{$student->emergencyContact->contact_number}}</p>
            <p class="text-gray-600 mt-2">
              <span
                class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm"
              >
               {{ $student->status }}
              </span>
            </p>
          </div>
        </div>

        <!-- Right Section: Buttons -->
        <div class="flex space-x-4">
          <button
            class="px-4 py-2 border border-gray-400 bg-white text-gray-600 flex items-center space-x-2" onclick="location.href='{{ route('student.edit', $student->id) }}'"
          >
            <i class="fas fa-edit"></i>
            <span>Edit Profile</span>
          </button>
        </div>
      </div>