<!DOCTYPE html>
<html>
<head>
    <title>Students PDF</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        table, th, td { border: 1px solid black; padding: 5px; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2 style="text-align: center;">{{ $schoolSettings['school_name'] ?? 'School' }} - Current Students List</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Student</th>
                <th>Email</th>
                <th>Roll No</th>
                <th>Class</th>
                <th>Section</th>
                <th>Phone</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($students as $index => $student)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $student->student_name }}</td>
                    <td>{{ $student->email }}</td>
                    <td>{{ $student->id }}</td>
                    <td>{{ $student->classes->first()->name ?? 'N/A' }}</td>
                    <td>
                        @foreach ($student->sections as $section)
                            {{ $section->name }}
                        @endforeach
                    </td>
                    <td>{{ $student->guardian->guardian_contact ?? 'N/A' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
