<!DOCTYPE html>
<html>
<head>
    <title>Alumni Students PDF</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; font-size: 12px; }
        th { background-color: #f0f0f0; }
    </style>
</head>
<body>
    <h2 style="text-align: center;">Alumni Students List</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Student</th>
                <th>Email</th>
                <th>Roll No</th>
                <th>Class</th>
                <th>Phone</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($students as $index => $student)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $student->student_name }}</td>
                    <td>{{ $student->email }}</td>
                    <td>{{ $student->reg_no }}</td>
                    <td>{{ $student->latestAdmission->class->name ?? 'N/A' }}</td>
                    <td>{{ $student->guardian->guardian_contact ?? 'N/A' }}</td>
                    <td>Completed</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
