@extends('schoolLayout.app')
@section('content')
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
        @include('student.stdProfilePartials')
        <!-- Tabs Section -->
        <div class="flex justify-between mt-4 w-full px-4 bg-white pt-2 border-b border-gray-200 items-center">
            <div class="flex space-x-4 bg-white">
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile', $student->id) }}'">
                    Admission & Personal Details
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="window.location.href='{{ route('student.profile.academic', $student->id) }}'">
                    Academic Information
                </button>
                {{-- <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold">
            Assignments & Homework
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold">
            Exam & Performance
          </button> --}}
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile.attendance', $student->id) }}'">
                    Attendance Records
                </button>
                <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile.documents', $student->id) }}'">
                    Documents & Certificates
                </button>
            </div>
        </div>

        <div class="flex justify-between items-center p-4 my-6">
            <!-- Left: Heading -->
            <h2 class="text-xl font-semibold text-gray-800">Document</h2>


        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">

            <!-- Card 1 -->
            @if (optional($student->documents)->birth_certificate)
                <div class="bg-white p-4 rounded-lg shadow-md">
                    <!-- First Row -->
                    <div class="flex justify-between items-center pb-2">
                        <div class="flex items-center space-x-4">
                            <i class="fa-solid fa-file-pdf text-red-500"></i>
                            <div>
                                <h3 class="text-lg font-semibold text-gray-800">
                                    Birth Certificate
                                </h3>
                                <p class="text-sm text-gray-600">PDF •
                                    {{ $student->documents->created_at->format('d M Y') }}</p>
                            </div>
                        </div>
                        <span
                            class="bg-[#FEE2E2] text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                            <i class="fa-solid fa-circle-check"></i> Verified
                        </span>
                    </div>
                    <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
                        <i class="fa-solid fa-eye cursor-pointer"></i>
                        <a href="{{ asset('storage/' . $student->documents->birth_certificate) }}"
                            download="birth_certificate_{{ $student->id }}" class="text-blue-500 hover:text-blue-700">
                            <i class="fa-solid fa-download cursor-pointer"></i>
                        </a>
                    </div>
                </div>
            @endif
            {{-- <div class="bg-white p-4 rounded-lg shadow-md">
          <!-- First Row -->
          <div class="flex justify-between items-center pb-2">
            <div class="flex items-center space-x-4">
                <i class="fa-solid fa-file-image text-blue-500"></i>
              <div>
                <h3 class="text-lg font-semibold text-gray-800">
                  Student ID Card
                </h3>
                <p class="text-sm text-gray-600">PNG • 12 Feb 2024</p>
              </div>
            </div>
            <span class="bg-[#FEE2E2]  text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                <i class="fa-solid fa-circle-check"></i></i> Verified
            </span>
          </div>
            <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
              <i class="fa-solid fa-eye cursor-pointer"></i>
              <i class="fa-solid fa-download cursor-pointer"></i>
            </div>
        </div> --}}
            @if (optional($student->documents)->school_leaving_certificate)
                <div class="bg-white p-4 rounded-lg shadow-md">
                    <!-- First Row -->
                    <div class="flex justify-between items-center pb-2">
                        <div class="flex items-center space-x-4">
                            <i class="fa-solid fa-file-pdf text-red-500"></i>
                            <div>
                                <h3 class="text-lg font-semibold text-gray-800">
                                    School Leaving Certificate
                                </h3>
                                <p class="text-sm text-gray-600">PDF •
                                    {{ $student->documents->created_at->format('d M Y') }}</p>
                            </div>
                        </div>
                        <span
                            class="bg-[#FEE2E2] text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                            <i class="fa-solid fa-circle-check"></i> Verified
                        </span>
                    </div>
                    <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
                        {{-- <p>{{ $student->documents->school_leaving_certificate }} here is </p> --}}
                        <i class="fa-solid fa-eye cursor-pointer"></i>
                        <a href="{{ asset('storage/' . $student->documents->school_leaving_certificate) }}"
                            download="school_leaving_certificate_{{ $student->id }}"
                            class="text-blue-500 hover:text-blue-700">
                            <i class="fa-solid fa-download cursor-pointer"></i>
                        </a>
                    </div>
                </div>
            @endif
            {{-- <div class="bg-white p-4 rounded-lg shadow-md">
          <!-- First Row -->
          <div class="flex justify-between items-center pb-2">
            <div class="flex items-center space-x-4">
                <i class="fa-solid fa-file-image text-blue-500"></i>
              <div>
                <h3 class="text-lg font-semibold text-gray-800">
                    Profile Picture
                </h3>
                <p class="text-sm text-gray-600">JPG • 15 Feb 2024</p>
              </div>
            </div>
            <span class="bg-[#FEE2E2]  text-[#991B1B] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                <i class="fa-solid fa-circle-check"></i></i> Verified
            </span>
          </div>
            <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
              <i class="fa-solid fa-eye cursor-pointer"></i>
              <i class="fa-solid fa-download cursor-pointer"></i>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md">
          <!-- First Row -->
          <div class="flex justify-between items-center pb-2">
            <div class="flex items-center space-x-4">
                <i class="fa-solid fa-file-pdf text-red-500"></i>
              <div>
                <h3 class="text-lg font-semibold text-gray-800">
                    Character Certificate
                </h3>
                <p class="text-sm text-gray-600">PDF • 20 Feb 2024</p>
              </div>
            </div>
            <span class="bg-[#FEF9C3]  text-[#854D0E] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                <i class="fa-solid fa-clock"></i>Pending
            </span>
          </div>
            <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
              <i class="fa-solid fa-eye cursor-pointer"></i>
              <i class="fa-solid fa-download cursor-pointer"></i>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-md">
          <!-- First Row -->
          <div class="flex justify-between items-center pb-2">
            <div class="flex items-center space-x-4">
                <i class="fa-solid fa-file-pdf text-red-500"></i>
              <div>
                <h3 class="text-lg font-semibold text-gray-800">
                    School Leaving Certificate
                </h3>
                <p class="text-sm text-gray-600">PDF • 25 Feb 2024</p>
              </div>
            </div>
            <span class="bg-[#FEF9C3]  text-[#854D0E] px-3 py-0.5 rounded-2xl text-sm inline-flex items-center gap-x-2">
                <i class="fa-solid fa-circle-xmark"></i>Pending
            </span>
          </div>
            <div class="flex space-x-3 text-blue-600 justify-end items-center mt-3">
              <i class="fa-solid fa-eye cursor-pointer"></i>
              <i class="fa-solid fa-download cursor-pointer"></i>
            </div>
        </div> --}}

        </div>
    </div>
@endsection
