<table class="w-full border-collapse">
    <thead>
        <tr class="text-gray-700 bg-gray-50 text-sm">
            <th class="p-3 text-center font-medium"><input type="checkbox" id="all_check" /></th>
            <th class="p-3 text-left font-semibold">Student</th>
            <th class="p-3 text-left font-semibold">Roll Number</th>
            <th class="p-3 text-left font-semibold">Class</th>
            <th class="p-3 text-left font-semibold">Phone</th>
            <th class="p-3 text-center font-semibold">Actions</th>
        </tr>
    </thead>
    <tbody class="bg-white rounded-lg shadow">
        @foreach ($students as $student)
            <tr class="border-b hover:bg-blue-50 transition">
                <td class="p-3 text-center">
                    <input type="checkbox" class="select_student" name="students[]" value="{{ $student->id }}" />
                </td>
                <td class="p-3 flex items-center gap-3">
                    <img src="{{ asset('assets/sidebar/student.png') }}" alt="Student"
                        class="w-10 h-10 rounded-full border border-gray-200 shadow-sm" />
                    <div>
                        <div class="font-semibold text-gray-800">{{ $student->student_name }}</div>
                        <div class="text-xs text-gray-500">{{ $student->email }}</div>
                    </div>
                </td>
                <!-- Roll Number -->
                <td class="p-3 text-gray-700">{{ $student->reg_no }}</td>
                <!-- Class -->
                <td class="p-3">
                    <span
                        class="bg-green-100 text-green-700 px-3 py-1 rounded-2xl text-xs font-semibold">Completed</span>
                </td>
                <!-- Phone -->
                <td class="p-3 text-gray-700">{{ $student->guardian->guardian_contact ?? 'N/A' }}</td>
                <!-- Actions -->
                <td class="p-3 text-center relative">
                    <button onclick="event.preventDefault();toggleDropdown(this)"
                        class="action-btn px-2 py-1 rounded hover:bg-gray-100 focus:outline-none" title="Actions">
                        <img src="{{ asset('assets/actions.png') }}" alt="icons" class="w-5 h-5" />
                    </button>
                    <div
                       class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 shadow-lg rounded-lg border">
                        <a href="{{ route('student.profile', $student->id) }}"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-eye text-blue-600"></i> View Details
                        </a>
                        <a href="{{ route('mark.as.current.single', $student->id) }}"
                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100 text-gray-700 text-sm">
                            <i class="fa-solid fa-graduation-cap text-yellow-600"></i> Mark as Current student
                        </a>
                    </div>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
