@extends('schoolLayout.app')
@section('content')
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
      @include('student.stdProfilePartials')

      <!-- Tabs Section -->
      <div
        class="flex justify-between mt-4 w-full px-4 bg-white pt-2 border-b border-gray-200 items-center"
      >
        <div class="flex space-x-4 bg-white">
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='{{ route('student.profile',$student->id) }}'">
            Admission & Personal Details
          </button>
          <button
            class="tab-btn px-4 pb-4 bg-white pt-2 border-b-2 border-blue-500 font-semibold text-blue-500"
          >
            Academic Information
          </button>
          {{-- <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold">
            Assignments & Homework
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold">
            Exam & Performance
          </button> --}}
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='{{ route('student.profile.attendance', $student->id) }}'">
            Attendance Records
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold" onclick="location.href='{{ route('student.profile.documents',$student->id) }}'">
              Documents & Certificates
          </button>
          <button class="tab-btn pb-4 pt-2 text-gray-500 font-semibold"
                    onclick="location.href='{{ route('student.profile.promote', $student->id) }}'">
                    Promote Student
                </button>
        </div>
      </div>

      <div class="flex gap-6 mt-10">
        <!-- Left Section (70%) -->
        <div class="w-[70%] bg-white shadow">
          <div class="flex justify-between pt-6 px-6 items-center">
            <h2 class="text-xl font-semibold mb-4">Course & Subjects</h2>

            {{-- <!-- Form Section -->
            <div class="grid grid-cols-2 gap-4 mb-6">
              <select class="border p-2 w-full">
                <option>All Subjects</option>
              </select>

              <select class="border p-2 w-full">
                <option>All Status</option>
              </select>
            </div> --}}
          </div>

          <!-- Table -->
          <table class="w-full border-collapse">
            <thead class="bg-[#f9fafc]">
              <tr class="text-gray-600">
                <th class="p-3 text-left font-medium">Subject</th>
                <th class="p-3 text-left font-medium">Teacher</th>
                <th class="p-3 text-left font-medium">Schedule</th>
              </tr>
            </thead>
            <tbody class="bg-white py-3 rounded-lg">
              @if ($subjects)
                @foreach ($subjects as $subject )
                  
                <tr class="border-b">
                  <td class="p-3 flex items-center font-semibold text-black">
                    {{ $subject->subjects->name }}
                  </td>
                  <td class="p-3 text-gray-500">{{ $subject->staff_member->full_name }}</td>
                  <td class="p-3 text-gray-500">{{ $subject->start_time  }} {{ $subject->end_time }}</td>
                </tr>

                @endforeach
                
              @endif
            </tbody>
          </table>
        </div>

        <!-- Right Section (30%) -->
        <div
          class="w-[30%] bg-white min-h-44 p-6 shadow rounded-lg self-start flex-grow-0"
        >
          <h2 class="text-xl font-semibold mb-2">Class Information</h2>
          <div class="mt-2">
            <h3 class="text-gray-400 text-md">Current Class</h3>
            @php
              $admission = $student->admissions->first();
            @endphp

            <p class="text-xl">{{ $admission->class->name}}</p>
          </div>
          {{-- <div class="mt-2">
            <h3 class="text-gray-400 text-md">Stream</h3>
            <p class="text-xl">Grade 10-A</p>
          </div> --}}
          <div class="mt-2">
            <h3 class="text-gray-400 text-md">Academic Year</h3>
            <p class="text-xl">{{ $student->latestAdmission->session_year }}</p>
          </div>
        </div>
      </div>

      <!-- Second Section - Weekly Schedule -->
      {{-- <div class="mt-8 bg-[#f9fafc]">
        <h2 class="text-xl font-semibold p-6">Weekly Schedule</h2>
        <div class="grid grid-cols-6">
          <div class="p-4 shadow w-full">
            <h3 class="font-semibold mb-1">Monday</h3>

            <div class="flex flex-col gap-2">
              <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                <h4 class="font-semibold text-lg text-[#1D4ED8]">
                  Mathematics
                </h4>
                <p class="text-[#3B82F6]">9:00 - 10:30</p>
              </div>

              <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                <h4 class="font-semibold text-lg text-[#15803D]">Physics</h4>
                <p class="text-[#22C55E]">11:00 - 12:30</p>
              </div>
            </div>
          </div>

          <div class="p-4 shadow w-full">
            <h3 class="font-semibold mb-1">Tuesday</h3>

            <div class="flex flex-col gap-2">
              <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                <h4 class="font-semibold text-lg text-[#1D4ED8]">Chemistry</h4>
                <p class="text-[#3B82F6]">9:00 - 10:30</p>
              </div>
            </div>
          </div>

          <div class="p-4 shadow w-full">
            <h3 class="font-semibold mb-1">Wednesday</h3>

            <div class="flex flex-col gap-2">
              <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                <h4 class="font-semibold text-lg text-[#1D4ED8]">Mathematics</h4>
                <p class="text-[#3B82F6]">9:00 - 10:30</p>
              </div>
            </div>
          </div>
          <div class="p-4 shadow w-full">
            <h3 class="font-semibold mb-1">Thursday</h3>

            <div class="flex flex-col gap-2">
                <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                    <h4 class="font-semibold text-lg text-[#15803D]">Physics</h4>
                    <p class="text-[#22C55E]">11:00 - 12:30</p>
                  </div>
            </div>
          </div>
          <div class="p-4 shadow w-full">
            <h3 class="font-semibold mb-1">Friday</h3>

            <div class="flex flex-col gap-2">
              <div class="bg-[#EFF6FF] rounded px-4 py-2 flex-1 min-w-[180px]">
                <h4 class="font-semibold text-lg text-[#1D4ED8]">Chemistry</h4>
                <p class="text-[#3B82F6]">9:00 - 10:30</p>
              </div>
            </div>
          </div>

          <div class="p-4 shadow">
            <h3 class="font-semibold">Saturday</h3>
            <p class="mt-2 text-gray-600">No Classes</p>
          </div>
        </div>
      </div> --}}
    </div>
@endsection
