@extends('schoolLayout.app')
@section('content')
    <!-- Section 1: Invoice Header -->
    <div class="flex justify-between p-6 items-center">
        <h2 class="text-2xl font-semibold">Invoice Details</h2>
        <span class="bg-green-200 text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
            Paid
        </span>
    </div>

    <div class="p-6">
        <!-- Section 2: Student & Invoice Details -->
        <div class="grid rounded-t-xl grid-cols-2 p-6 bg-white gap-6 mt-2">
            <!-- Student Details -->
            <div class="p-4">
                <h3 class="text-lg font-semibold mb-1">School Information</h3>
                <p class="text-gray-600">Brightwood Academy</p>
                <p class="text-gray-600">123 Education Street</p>
                <p class="text-gray-600">New York, NY 10001</p>
                <p class="text-gray-600">Tel: (555) 123-4567</p>
            </div>

            <!-- Invoice Details -->
            <div class="p-4">
                <h3 class="text-lg font-semibold mb-4">Invoice Details</h3>
                <div class="grid grid-cols-2 gap-4">
                    <p class="flex font-semibold flex-col gap-y-1">
                        <span class="font-medium text-gray-600">Invoice No</span>
                        INV-2023101
                    </p>
                    <p class="flex font-semibold flex-col gap-y-1">
                        <span class="font-medium text-gray-600">Date Issued</span> 01 Jan
                        2024
                    </p>
                    <p class="flex font-semibold flex-col gap-y-1">
                        <span class="font-medium text-gray-600">Due Date</span> 15 Jan
                        2024
                    </p>
                    <p class="flex font-semibold flex-col gap-y-1">
                        <span class="font-medium text-gray-600">Student ID</span>
                        STU-12345
                    </p>
                </div>
            </div>
        </div>

        <!-- Section 3: Fee Breakdown -->
        <div class="bg-white p-4 border-t border-gray-200">
            <h3 class="text-lg font-semibold mb-4">Fee Breakdown</h3>
            <table class="w-full border border-gray-300 text-left">
                <thead class="bg-[#f9fafc]">
                    <tr>
                        <th class="p-2 border text-gray-600 font-medium">Description</th>
                        <th class="p-2 border text-gray-600 font-medium">Amount</th>
                        <th class="p-2 border text-gray-600 font-medium">Discount</th>
                        <th class="p-2 border text-gray-600 font-medium">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="p-2 border font-semibold">Tuition Fee</td>
                        <td class="p-2 border">$500</td>
                        <td class="p-2 border">$50</td>
                        <td class="p-2 border">$450</td>
                    </tr>
                    <tr>
                        <td class="p-2 border font-semibold">Library Fee</td>
                        <td class="p-2 border">$50</td>
                        <td class="p-2 border">$5</td>
                        <td class="p-2 border">$45</td>
                    </tr>
                    <tr>
                        <td class="p-2 border font-semibold">Total</td>
                        <td class="p-2 border">$550</td>
                        <td class="p-2 border">$55</td>
                        <td class="p-2 border">$495</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Section 4: Payment History -->
        <div class="bg-white p-4 border-t rounded-b-xl border-gray-200">
            <h3 class="text-lg font-semibold mb-4">Payment History</h3>
            <div class="flex justify-between px-4 py-2 rounded-xl bg-[#f9fafc]">
                <div>
                    <h1 class="font-semibold">Payment #1</h1>
                    <p class="text-gray-600">Jan 15, 2025</p>
                </div>
                <div>
                    <h1 class="font-semibold">$5050.00</h1>
                    <p class="text-gray-600">Credit Card</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Section 5: Action Buttons -->
    <div class="flex bg-white border-t border-gray-200 justify-end gap-4 mt-6 p-4">
        <button class="flex items-center text-gray-700 gap-2 px-4 py-2 border border-gray-600 rounded-lg hover:bg-gray-200">
            <i class="fa-solid fa-print"></i> Print
        </button>
        <button class="flex items-center text-gray-700 gap-2 px-4 py-2 border border-gray-600 rounded-lg hover:bg-gray-200">
            <i class="fa-solid fa-file-pdf"></i> Download PDF
        </button>
        <button class="flex items-center text-gray-700 gap-2 px-4 py-2 border border-gray-600 rounded-lg hover:bg-gray-200">
            <i class="fa-solid fa-envelope"></i> Email Invoice
        </button>
    </div>
@endsection
