<!DOCTYPE html>
<html>
<head>
    <title>Student Assign Fee Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 4px; text-align: center; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2 style="text-align: center;">Student Assign Fee Report</h2>

    <table>
        <thead>
            <tr>
                <th>Student</th>
                <th>Reg No</th>
                <th>Status</th>
                <th>Class</th>
                <th>Adm</th>
                <th>Prom</th>
                <th>Sch</th>
                <th>Sport</th>
                <th>Tution</th>
                <th>Lab</th>
                <th>Exam</th>
                <th>Board</th>
                <th>Ent</th>
                <th>Other</th>
                <th>Book</th>
                <th>Annual</th>
                <th>2nd Fee</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($fees as $f)
                <tr>
                    <td>{{ $f->student->student_name ?? 'N/A' }}</td>
                    <td>{{ $f->reg_no }}</td>
                    <td>{{ $f->status ?? 'active' }}</td>
                    <td>{{ $f->class->name ?? '' }}</td>
                    <td>{{ number_format($f->admission_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->promotion_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->scholarship_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->sport_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->tuition_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->lab_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->exam_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->board_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->entertainment_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->other_fee ?? 0, 0) }}</td>
                    <td>{{ number_format($f->book_charges ?? 0, 0) }}</td>
                    <td>{{ number_format($f->annual_charges ?? 0, 0) }}</td>
                    <td>{{ number_format($f->second_time_fee ?? 0, 0) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="17">No data found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
