<div class="overflow-x-auto">
    <table class="w-full border-collapse text-sm">
        <thead class="sticky top-0 bg-white">
            <tr class="text-gray-600">
                <th class="p-2 text-left font-medium min-w-[120px]">Student</th>
                <th class="p-2 text-center font-medium">Reg No</th>
                <th class="p-2 text-center font-medium">Status</th>
                <th class="p-2 text-left font-medium">Class</th>
                <th class="p-2 text-right font-medium" title="Admission Fee">Adm</th>
                <th class="p-2 text-right font-medium" title="Promotion Fee">Prom</th>
                <th class="p-2 text-right font-medium" title="Scholarship Fee">Sch</th>
                <th class="p-2 text-right font-medium" title="Sport Fee">Sport</th>
                <th class="p-2 text-right font-medium">Tution</th>
                <th class="p-2 text-right font-medium">Lab</th>
                <th class="p-2 text-right font-medium">Exam</th>
                <th class="p-2 text-right font-medium">Board</th>
                <th class="p-2 text-right font-medium" title="Entertainment Fee">Ent</th>
                <th class="p-2 text-right font-medium">Other</th>
                <th class="p-2 text-right font-medium">Book</th>
                <th class="p-2 text-right font-medium" title="Annual Charges">Annual</th>
                <th class="p-2 text-right font-medium">2nd Fee</th>
                <th class="p-2 text-center font-medium min-w-[80px]">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($fees as $index => $f)
                <tr class="border-b {{ $index % 2 === 0 ? 'bg-blue-200' : 'bg-white' }} ">
                    <td class="p-2 text-left">{{ $f->student->student_name ?? 'N/A' }}</td>
                    <td class="p-2 text-center">{{ $f->reg_no }}</td>
                    <td class="p-2 text-center">{{ $f->status ?? 'active' }}</td>
                    <td class="p-2 text-left">{{ $f->class->name ?? '' }}</td>
                    <td class="p-2 text-right">{{ number_format($f->admission_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->promotion_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->scholarship_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->sport_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->tuition_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->lab_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->exam_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->board_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->entertainment_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->other_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->book_charges ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->annual_charges ?? 0, 0) }}</td>
                    <td class="p-2 text-right">{{ number_format($f->second_time_fee ?? 0, 0) }}</td>
                    <td class="p-2 text-center relative">
                        <button class="openEditModalBtn text-blue-700 font-semibold text-sm"
                            data-id="{{ $f->id }}" data-student="{{ $f->student->student_name }}"
                            data-reg="{{ $f->reg_no }}" data-class="{{ $f->class_id }}"
                            data-admission="{{ $f->admission_fee }}" data-promotion="{{ $f->promotion_fee }}"
                            data-scholarship="{{ $f->scholarship_fee }}" data-sport="{{ $f->sport_fee }}"
                            data-tuition="{{ $f->tuition_fee }}" data-lab="{{ $f->lab_fee }}"
                            data-exam="{{ $f->exam_fee }}" data-board="{{ $f->board_fee }}"
                            data-ent="{{ $f->entertainment_fee }}" data-other="{{ $f->other_fee }}"
                            data-book="{{ $f->book_charges }}" data-annual="{{ $f->annual_charges }}"
                            data-second="{{ $f->second_time_fee }}">
                            Edit
                        </button>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="23" class="text-center text-gray-500 py-4">No Data Found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
