@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <!-- Header Section -->
    <div class="flex justify-between items-center">
        <div class="flex justify-between items-center">
            <!-- Tabs -->
            @include('stdFeeMgt.partialhead')
        </div>

    </div>
    <div class="flex  w-full bg-white">
        <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
            Fee Generated Report
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl"></span>
        </button>
        {{--  <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Total Generated Fee
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl">2222</span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Total Not Generated
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl">55</span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Other
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl">444</span>
        </button> --}}
    </div>
    <div class="flex items-center mt-4 space-x-4">

        <select id="student-search" name="student-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Student</option>
            @foreach ($stdList as $s)
                <option value="{{ $s->head_code }}">
                    {{ $s->student_name }} - {{ $s->reg_no }}
                </option>
            @endforeach
        </select>
        <select id="class-search" name="class-search" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">Select Class</option>
            @foreach ($classList as $c)
                <option value="{{ $c->id }}">
                    {{ $c->name }}
                </option>
            @endforeach
        </select>
        <div class="flex items-center mt-4 space-x-4">
            <input type="date" id="from-date" class="border p-2 rounded-lg">
            <input type="date" id="to-date" class="border p-2 rounded-lg">

            <button id="download-pdf" class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600">
                PDF
            </button>
        </div>

    </div>
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="student-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('stdFeeMgt.partialFeeGen', ['fees' => $fees])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $fees->firstItem() }} to {{ $fees->lastItem() }} of {{ $fees->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="40" {{ request('entries') == 40 ? 'selected' : '' }}>40</option>
                    <option value="80" {{ request('entries') == 80 ? 'selected' : '' }}>80</option>
                    <option value="120" {{ request('entries') == 120 ? 'selected' : '' }}>120</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $fees->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}

        </div>
    </div>

    <script>
        $('#download-pdf').on('click', function() {
            let student = $('#student-search').val();
            let classId = $('#class-search').val();
            let fromDate = $('#from-date').val();
            let toDate = $('#to-date').val();

            let url = "{{ route('fee.gen.report.pdf') }}";
            let params = [];

            if (student) params.push('search=' + student);
            if (classId) params.push('class_search=' + classId);
            if (fromDate) params.push('from_date=' + fromDate);
            if (toDate) params.push('to_date=' + toDate);

            if (params.length > 0) {
                url += '?' + params.join('&');
            }

            window.open(url, '_blank');
        });


        $(document).ready(function() {
            $('.select2').select2({
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });

        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#student-search').on('change', function() {
            let selectedStudent = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedStudent) {
                $.ajax({
                    url: "{{ route('fee.gen.index') }}",
                    type: "GET",
                    data: {
                        search: selectedStudent // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#student-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });

        $('#class-search').on('change', function() {
            let selectedClass = $(this).val(); // Get the selected student value

            // Only trigger the AJAX call if a valid student is selected
            if (selectedClass) {
                $.ajax({
                    url: "{{ route('fee.gen.index') }}",
                    type: "GET",
                    data: {
                        class_search: selectedClass // Send the selected student value in the AJAX request
                    },
                    success: function(data) {
                        $('#student-table').html(data); // Update the student table with the new data
                    }
                });
            }
        });

        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
