@extends('schoolLayout.app')
@section('content')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Fee Records
                </button>
                <button class="tab-btn pb-3 text-gray-700 font-semibold">
                    Fines & Exam Fee
                </button>
            </div>
        </div>
        <div class="bg-white border border-gray-200 px-2 rounded-md shadow-sm">
            <div class="flex justify-between px-4 bg-white pt-2 border-b border-gray-200 items-center">
                <!-- Tabs:-->
                <div class="flex space-x-4 bg-white">
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Categories
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Student's Fees
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Invoices
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Refund Payments
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee History
                    </button>
                    <button class="tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                        Fee Reminders
                    </button>
                </div>
            </div>
            <div class="mt-4 px-4">
                <h1 class="text-lg font-semibold text-gray-600 mb-4">
                    Send Reminders To
                </h1>
                <div class="flex flex-wrap gap-4 bg-white items-center">
                    <!-- All Schools -->
                    <div class="flex flex-col items-start space-y-2">
                        <label class="flex items-center text-gray-600 space-x-2">
                            <input type="radio" class="rounded" />
                            <span>All Schools</span>
                        </label>
                    </div>

                    <!-- Campus -->
                    <div class="flex flex-col items-start space-y-2">
                        <label class="flex items-center text-gray-600 space-x-2">
                            <input type="radio" class="rounded" />
                            <span>Campus</span>
                        </label>
                        <select class="border rounded p-1">
                            <option>Select Campus</option>
                            <option>Campus 1</option>
                            <option>Campus 2</option>
                        </select>
                    </div>

                    <!-- Class -->
                    <div class="flex flex-col items-start space-y-2">
                        <label class="flex items-center text-gray-600 space-x-2">
                            <input type="radio" class="rounded" />
                            <span>Class</span>
                        </label>
                        <select class="border rounded p-1">
                            <option>Select Class</option>
                            <option>Class 10</option>
                            <option>Class 12</option>
                        </select>
                    </div>

                    <!-- Section -->
                    <div class="flex flex-col items-start space-y-2">
                        <label class="flex items-center text-gray-600 space-x-2">
                            <input type="radio" class="rounded" />
                            <span>Section</span>
                        </label>
                        <select class="border rounded p-1">
                            <option>Select Section</option>
                            <option>Section A</option>
                            <option>Section B</option>
                        </select>
                    </div>

                    <!-- Individual Student -->
                    <div class="flex flex-col items-start space-y-2">
                        <label class="flex items-center text-gray-600 space-x-2">
                            <input type="radio" class="rounded" />
                            <span>Individual Student</span>
                        </label>
                        <select class="border rounded p-1">
                            <option>Select Student</option>
                            <option>John Doe</option>
                            <option>Jane Smith</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="w-full bg-white pt-6 px-6">
                <form class="space-y-4">
                    <!-- Subject (Full Width) -->
                    <div>
                        <label class="block text-md text-gray-700 font-semibold mb-2">Subject</label>
                        <input type="text" class="w-full p-2 border rounded" placeholder="Enter subject" required />
                    </div>

                    <!-- Message (Full Width Textarea) -->
                    <div>
                        <label class="block text-md font-semibold text-gray-700 mb-2">Message</label>
                        <textarea class="w-full p-2 border rounded h-24" placeholder="Payment Reminder: School Fees Due" required></textarea>
                    </div>

                    <!-- Schedule & Repeat (Two Columns) -->
                    <div class="grid grid-cols-2 gap-4">
                        <!-- Schedule -->
                        <div>
                            <label class="block text-md font-semibold mb-2 text-gray-700">Schedule</label>
                            <input type="datetime-local" class="w-full p-2 border rounded" required />
                        </div>

                        <!-- Repeat -->
                        <div>
                            <label class="block text-md font-semibold mb-2 text-gray-700">Repeat</label>
                            <select class="w-full p-2 border rounded">
                                <option value="Never">Never</option>
                                <option value="Daily">Daily</option>
                                <option value="Weekly">Weekly</option>
                            </select>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex justify-end items-center">
                        <button
                            class="bg-[#0197FF] text-white px-4 flex items-center gap-x-2 py-2 rounded hover:bg-blue-700">
                            <i class="fa-solid fa-paper-plane"></i>
                            Send Reminder
                        </button>
                    </div>
                </form>
            </div>

        </div>
        <div class="w-full mt-8 ">
            <h2 class="text-xl font-semibold mb-4">Recent Reminders</h2>

            <div class="overflow-x-auto border border-gray-200 shadow-sm rounded-lg">
                <table class="w-full rounded-lg ">
                    <thead class="bg-transparent ">
                        <tr class="text-gray-700">
                            <th class="border p-3 text-left">Send To</th>
                            <th class="border p-3 text-left">Subject</th>
                            <th class="border p-3 text-left">Message</th>
                            <th class="border p-3 text-left">Last Reminder</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-700 bg-white">
                        <tr class="border">
                            <td class="border p-3">John Smith</td>
                            <td class="border p-3">Grade 10A</td>
                            <td class="border p-3">$1,200</td>
                            <td class="border p-3">2 days ago</td>
                        </tr>
                        <tr class="border">
                            <td class="border p-3">Emma Johnson</td>
                            <td class="border p-3">Grade 11B</td>
                            <td class="border p-3">$900</td>
                            <td class="border p-3">1 day ago</td>
                        </tr>
                        <tr class="border">
                            <td class="border p-3">Michael Brown</td>
                            <td class="border p-3">Grade 9C</td>
                            <td class="border p-3">$1,500</td>
                            <td class="border p-3">3 days ago</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script>
        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
