@extends('schoolLayout.app')
@section('content')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Fee Records
                </button>
                <button class="tab-btn pb-3 text-gray-700 font-semibold">
                    Fines & Exam Fee
                </button>
            </div>
        </div>
        <div class="bg-white border border-gray-200 px-2 rounded-md shadow-sm">
            <div class="flex justify-between px-4 bg-white py-2 border-b border-gray-200 items-center">
                <!-- Tabs:-->
                <div class="flex space-x-4 bg-white">
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Categories
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Student's Fees
                    </button>
                    <button class="tab-btn px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                        Fee Invoices
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Refund Payments
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee History
                    </button>
                    <button class="tab-btn text-gray-500 font-semibold">
                        Fee Reminders
                    </button>
                </div>
            </div>
            <div class="rounded-lg mt-4">
                <!-- Filters Section -->
                <div class="bg-white p-3 flex justify-between rounded-lg items-center gap-4">
                    <div class="relative w-[40%] rounded-lg">
                        <div class="border border-gray-200 rounded-sm bg-white flex items-center px-4">
                            <span class="text-gray-500">
                                <img src="{{ asset('/assets/search.png') }}" alt="icon" />
                            </span>
                            <input type="text" placeholder="Search by Invoice No, Student Name or ID"
                                class="w-full px-4 pr-8 py-2 text-sm border-none rounded-lg focus:outline-none" />
                        </div>
                    </div>
                    <div class="flex gap-x-2 items-center">
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Status</option>
                        </select>
                        <input type="date" class="border p-2 rounded-lg min-w-[130px] text-gray-600" />
                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Classes</option>
                        </select>

                        <select class="border p-2 min-w-[100px] rounded-lg">
                            <option>All Sections</option>
                        </select>
                        <button class="bg-[#F3F4F6] text-md rounded-lg px-2 py-2 rounded-sm text-nowrap">
                            Clear Filters
                        </button>
                    </div>
                </div>
                <div class="flex gap-2 px-6 items-center">
                    <!-- Selected Count -->
                    <span class="text-gray-600">
                        <input type="checkbox" name="" id="" />
                        0 Selected</span>

                    <!-- Mark as Paid Button -->
                    <button class="flex items-center gap-2 bg-[#F3F4F6] text-gray-700  px-3 py-1 rounded-lg">
                        <i class="fa-solid fa-check"></i>
                        Mark as Paid
                    </button>

                    <!-- Print Button -->
                    <button class="flex items-center gap-2 bg-[#F3F4F6] text-gray-700  px-3 py-1 rounded-lg">
                        <i class="fa-solid fa-print"></i>
                        Print
                    </button>

                    <!-- Delete Button -->
                    <button class="flex items-center gap-2 bg-[#F3F4F6] text-gray-700  px-3 py-1 rounded-lg">
                        <i class="fa-solid fa-trash"></i>
                        Delete
                    </button>

                    <!-- Send Reminder Button -->
                    <button class="flex items-center gap-2 bg-[#F3F4F6] text-gray-700  px-3 py-1 rounded-lg">
                        <i class="fa-solid fa-bell"></i>
                        Send Reminder
                    </button>
                </div>

                <div class="bg-white py-3 rounded-lg relative">
                    <table class="w-full border-collapse">
                        <thead class="bg-[#f9fafc]">
                            <tr class="text-gray-600">
                                <th class="p-3 text-center font-medium">
                                    <input type="checkbox" />
                                </th>
                                <th class="p-3 text-left font-semibold">Invoice No</th>
                                <th class="p-3 text-left font-semibold">Student</th>
                                <th class="p-3 text-left font-semibold">Class/Section</th>
                                <th class="p-3 text-left font-semibold">Invoice Date</th>
                                <th class="p-3 text-left font-semibold">Due Date</th>
                                <th class="p-3 text-left font-semibold">Total Amount</th>
                                <th class="p-3 text-left font-semibold">Status</th>
                                <th class="p-3 text-left font-semibold">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Invoice Row -->
                            <tr class="border-b">
                                <td class="p-3 text-center"><input type="checkbox" /></td>
                                <td class="p-3">INV-222-000</td>
                                <td class="p-3 text-gray-500">
                                    <div class="flex flex-col">
                                        <p class="font-semibold text-black">John Smith</p>
                                        <p>ID-SD001</p>
                                    </div>
                                </td>
                                <td class="p-3 text-gray-500">Class 10A</td>
                                <td class="p-3 text-gray-700">Jan 15, 2024</td>
                                <td class="p-3 text-gray-700">Feb 15, 2024</td>
                                <td class="p-3 text-black">$1,200.00</td>
                                <td class="p-3 text-left text-gray-500">
                                    <span class="bg-[#FEF9C3] text-[#854D0E] px-2 py-0.5 rounded-2xl text-sm">
                                        Pending
                                    </span>
                                </td>

                                <td class="p-3 text-center relative">
                                    <button onclick="toggleDropdown(this)" class="action-btn">
                                        <img src="{{ asset('/assets/actions.png') }}" alt="icons" class=" " />
                                    </button>
                                    <div
                                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Print</a>
                                        <a href="#"
                                            class="flex gap-x-2 items-center px-3 text-black py-2 text-nowrap hover:bg-red-100">View
                                            Details</a>
                                    </div>
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="p-3 text-center"><input type="checkbox" /></td>
                                <td class="p-3">INV-222-000</td>
                                <td class="p-3 text-gray-500">
                                    <div class="flex flex-col">
                                        <p class="font-semibold text-black">John Smith</p>
                                        <p>ID-SD001</p>
                                    </div>
                                </td>
                                <td class="p-3 text-gray-500">Class 10A</td>
                                <td class="p-3 text-gray-700">Jan 15, 2024</td>
                                <td class="p-3 text-gray-700">Feb 15, 2024</td>
                                <td class="p-3 text-black">$1,200.00</td>
                                <td class="p-3 text-left text-gray-500">
                                    <span class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                        Paid
                                    </span>
                                </td>

                                <td class="p-3 text-center relative">
                                    <button onclick="toggleDropdown(this)" class="action-btn">
                                        <img src="{{ asset('/assets/actions.png') }}" alt="icons" class=" " />
                                    </button>
                                    <div
                                        class="action-dropdown bg-white z-50 hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-lg border">
                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Edit</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Delete</a>

                                        <a href="#"
                                            class="flex items-center gap-x-2 px-3 py-2 hover:bg-gray-100">Print</a>
                                        <a href="#"
                                            class="flex gap-x-2 items-center px-3 text-black py-2 text-nowrap hover:bg-red-100">View</a>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="flex justify-between border-t mt-10 border-gray-200 bg-white items-center pt-4 p-4">
                        <p class="text-gray-500 text-sm">Showing 1 of 12 enteries</p>
                        <div class="flex space-x-2">
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Previous
                            </button>
                            <button class="px-3 py-1 border border-gray-400 bg-blue-700 text-white rounded-lg">
                                1
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                2
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                3
                            </button>
                            <button class="px-3 py-1 border border-gray-400 rounded-lg">
                                Next
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
