@extends('schoolLayout.app')
@section('content')
    <!-- Header -->
    <header class="flex justify-between items-center p-4">
        @if (session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                <strong class="font-bold">Error:</strong>
                <span class="block sm:inline">{{ session('error') }}</span>
            </div>
        @endif

        @if (session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                <strong class="font-bold">Success:</strong>
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="flex gap-x-2 items-center">
            <i class="fa-solid fa-arrow-left"></i>
            <h1 class="text-xl font-bold text-gray-800">ID Card Customization</h1>
        </div>
        <div class="flex gap-x-2 items-center">
            <button
                class="px-4 py-2 flex items-center gap-x-2 bg-white border border-gray-400 text-gray-700 rounded-md hover:bg-gray-400">
                <i class="fa-solid fa-arrow-rotate-left"></i>
                Reset
            </button>
            <button class="px-4 py-2 bg-[#0197FF] gap-x-2 flex items-center text-white rounded-md hover:bg-blue-700"
                onclick="submitForm()">
                <i class="fa-solid fa-floppy-disk"></i>Save Changes
            </button>
        </div>
    </header>

    <!-- Main Content -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
        <!-- Card Preview -->

        {{-- template_left --}}
        @if ($card && $card->template_name == 'template_left')
            <div class="border border-gray-200 rounded-lg p-4" id="card1_div">
                <div class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white "
                    id="card_preview"
                    style="
              background: {{ $card->background_color }};
              color: {{ $card->text_color }};

            ">
                    <img src="{{ asset('assets/card-image.png') }}" alt="Student Pic" class="rounded-md"
                        style="width: {{ $card->photo_width }}px;height: {{ $card->photo_height }}px;" />
                    <div class="flex-1 px-4 text-sm">
                        <h2 class="text-lg font-bold">STUDENT ID CARD</h2>
                        <p class="opacity-90 my-2">Modern Design</p>

                        <div class="text-md">
                            <p class="flex gap-x-2">Name: <span>John Smith</span></p>
                            <p class="flex gap-x-2">Roll No: <span>ST2024001</span></p>
                            <p class="flex gap-x-2">Contact: <span>+1 234 567 890</span></p>
                        </div>
                    </div>

                    <img @if ($card->logo != null) src="{{ asset('storage/' . $card->logo) }}"
            @else
            src="{{ asset('assets/logo.png') }}" @endif
                        alt="School Logo" class=" "
                        style="width: {{ $card->logo_width }}px;height: {{ $card->logo_height }}px;" />
                </div>
            </div>
        @endif

        {{-- template_right --}}
        @if ($card && $card->template_name == 'template_right')
            <div class="border border-gray-200 rounded-lg p-4" id="card2_div">
                <div class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white "
                    id="card_preview"
                    style="
                background:{{ $card->background_color }};
                color: {{ $card->text_color }};

              ">
                    <div class="w-1/2">
                        <h2 class="text-lg font-bold">CENTRAL HIGH SCHOOL</h2>
                        <div class="text-md mt-2 text-nowrap">
                            <p class="flex gap-x-4">Name: <span>John Smith</span></p>
                            <p class="flex gap-x-4">Roll No: <span>ST2024001</span></p>
                            <p class="flex gap-x-4">Class: <span>Grade 10</span></p>
                            <p class="flex gap-x-4">Contact: <span>+1 234 567 890</span></p>
                        </div>
                    </div>
                    <div class="w-1/2 flex flex-col items-center mt-2">
                        <img src="{{ asset('assets/card-image.png') }}" alt="Student Pic" class="rounded-md"
                            style="width: {{ $card->photo_width }}px;height: {{ $card->photo_height }}px;" />
                        <img @if ($card->logo != null) src="{{ asset('storage/' . $card->logo) }}"
                    @else
                    src="{{ asset('assets/logo.png') }}" @endif
                            alt="School Logo" class="mx-auto mt-3"
                            style="width: {{ $card->logo_width }}px;height: {{ $card->logo_height }}px;" />
                    </div>
                </div>
            </div>
        @endif
        {{-- template_bottom --}}
        @if ($card && $card->template_name == 'template_bottom')
            <div class="border border-gray-200 rounded-lg p-4" id="card3_div">
                <div class="flex shadow-lg rounded-lg p-4 w-[350px] h-[200px] border border-gray-200 text-white "
                    id="card_preview"
                    style="
                  background: {{ $card->background_color }};
                  color: {{ $card->text_color }};
                ">
                    <!-- Left Side: Text Content -->
                    <div class="flex items-center w-[70%] flex-col">
                        <h2 class="text-lg font-bold text-nowrap">
                            STUDENT IDENTIFICATION
                        </h2>

                        <div class="text-sm flex flex-col gap-y-2 mt-2">
                            <p>Student Name:John Smith</p>
                            <p>ID Number: ST2024001</p>
                            <p>Academic Year: 2023-2024</p>
                            <p>Emergency Contact: +1 234 567 890</p>
                        </div>
                    </div>

                    <!-- Right Side: Logo & Image -->
                    <div class="w-[30%] flex flex-col justify-between">
                        <img @if ($card->logo != null) src="{{ asset('storage/' . $card->logo) }}"
                    @else
                    src="{{ asset('assets/logo.png') }}" @endif
                            alt="School Logo" class="mx-auto mt-2"
                            style="width: {{ $card->logo_width }}px;height: {{ $card->logo_height }}px;" />
                        <img src="{{ asset('assets/third.png') }}" alt="Student Pic" class="rounded-md mx-auto mt-3"
                            style="width: {{ $card->photo_width }}px;height: {{ $card->photo_height }}px;" />
                    </div>
                </div>
            </div>
        @endif

        <!-- Customization Settings -->
        <div class=" rounded-lg">
            <div class="p-4 bg-white">
                <h2 class="text-lg font-semibold mb-4">Color Settings</h2>
                <!-- Background Color -->
                <div class="flex gap-y-2 flex-col w-full justify-between mb-4">
                    <label class="text-gray-700">Background Color</label>
                    <div class="flex items-center">
                        <input type="color" id="bg-color-picker" class="cursor-pointer h-6"
                            value="{{ $card->background_color }}" onchange="background_color(this.value)" />
                        <input type="text" id="bg-hex" class="ml-2 w-full p-1 border rounded-md"
                            value = "{{ $card->background_color }}" />
                    </div>
                </div>

                <!-- Text Color -->
                <div class="flex gap-y-2 flex-col w-full justify-between mb-4">
                    <label class="text-gray-700">Text Color</label>
                    <div class="flex items-center">
                        <input type="color" id="text-color-picker" class="cursor-pointer h-6"
                            value="{{ $card->text_color }}" onchange="text_color(this.value)" />
                        <input type="text" id="text-hex" class="ml-2 w-full p-1 border rounded-md"
                            value="{{ $card->text_color }}" />
                    </div>
                </div>
            </div>

            <!-- Upload Logo -->
            <div class="bg-white p-4 mt-4">
                <div class="my-2">
                    <!-- Student Photo Upload -->
                    <div>
                        <label class="block font-bold mb-1">Upload Logo</label>
                        <label
                            class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                            <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                            <span class="text-sm text-gray-500 mt-2">Drag and drop your photo here, <br />
                                or <span class="text-black">browse files</span></span>
                            <span class="text-xs text-gray-400 mt-1">Supported formats: PNG, JPG, SVG (max 2MB)</span>
                            <input type="file" class="hidden" id="logo" accept="image/png, image/jpeg" />
                        </label>
                    </div>
                </div>
            </div>

            <!-- Element Positioning -->
            {{-- <div class="bg-white p-4 mt-4">
            <h2 class="text-lg font-semibold mb-4">Element Positioning</h2>

            <!-- Photo Size -->
            <div class="mb-1">
              <label class="text-gray-700 block">Photo Size:</label>
              <input
                type="range"
                id="photo-size"
                min="40"
                max="120"
                value="80"
                class="w-full"
                name="photo_size"
              />
            </div>

            <!-- Logo Size -->
            <div class="mb-4">
              <label class="text-gray-700 block">Logo Size:</label>
              <input
                type="range"
                id="logo-size"
                min="30"
                max="100"
                value="50"
                class="w-full"
                name="logo_size"
              />
            </div>
        </div> --}}
        </div>
    </div>
    <form action="{{ route('student.card-customize.store', $card->template_name) }}" enctype="multipart/form-data"
        method="post" id="card_form" class="hidden">
        @csrf
        <input type="text" name="background_color" id="form_background_color" value="{{ $card->background_color }}">
        <input type="text" name="text_color" id="form_text_color" value="{{ $card->text_color }}">
        <input type="file" name="logo" id="form_logo">
    </form>
@endsection

@section('script')
    <script>
        // // Update Background Color
        // document
        //   .getElementById("bg-color-picker")
        //   .addEventListener("input", function () {
        //     let color = this.value;
        //     document.getElementById("card-preview").style.backgroundColor = color;
        //     document.getElementById("bg-color-box").style.backgroundColor = color;
        //     document.getElementById("bg-hex").value = color;
        //   });

        // // Update Text Color
        // document
        //   .getElementById("text-color-picker")
        //   .addEventListener("input", function () {
        //     let color = this.value;
        //     document
        //       .querySelectorAll("#card-preview p")
        //       .forEach((el) => (el.style.color = color));
        //     document.getElementById("text-color-box").style.backgroundColor =
        //       color;
        //     document.getElementById("text-hex").value = color;
        //   });

        // // Upload Logo
        // document
        //   .getElementById("logo-upload")
        //   .addEventListener("change", function (event) {
        //     const file = event.target.files[0];
        //     if (file) {
        //       const reader = new FileReader();
        //       reader.onload = function (e) {
        //         document.getElementById("preview-logo").src = e.target.result;
        //       };
        //       reader.readAsDataURL(file);
        //     }
        //   });

        // // Adjust Photo Size
        // document
        //   .getElementById("photo-size")
        //   .addEventListener("input", function () {
        //     document.getElementById("preview-image").style.width =
        //       this.value + "px";
        //     document.getElementById("preview-image").style.height =
        //       this.value + "px";
        //   });

        // // Adjust Logo Size
        // document
        //   .getElementById("logo-size")
        //   .addEventListener("input", function () {
        //     document.getElementById("preview-logo").style.width =
        //       this.value + "px";
        //     document.getElementById("preview-logo").style.height =
        //       this.value + "px";
        //   });
    </script>

    <script>
        function background_color(color) {
            // let color = document.getElementById("bg-color-picker").value;
            // alert(color);
            let card = document.querySelector('#card_preview');
            card.style.background = color;
        }

        function text_color(color) {
            let card = document.querySelector('#card_preview');
            card.style.color = color;
        }

        function syncColor(colorPickerId, hexInputId) {
            const colorPicker = document.getElementById(colorPickerId);
            const hexInput = document.getElementById(hexInputId);

            // Sync color picker with hex input
            colorPicker.addEventListener("input", function() {
                hexInput.value = this.value.toUpperCase();
            });

            // Sync hex input with color picker
            hexInput.addEventListener("input", function() {
                if (/^#([0-9A-F]{3}){1,2}$/i.test(this.value)) {
                    colorPicker.value = this.value;
                }
            });
        }

        function submitForm() {
            let bg_color = document.getElementById('bg-hex').value;
            let text_color = document.getElementById('text-hex').value;
            if (document.getElementById('logo').files[0]) {

                let logo = document.getElementById('logo').files[0];
                let form_logo = document.getElementById('form_logo');
                let dataTransfer = new DataTransfer();

                dataTransfer.items.add(logo);
                form_logo.files = dataTransfer.files;
            }
            let form_background_color = document.getElementById('form_background_color').value = bg_color;
            let form_text_color = document.getElementById('form_text_color').value = text_color;
            let form = document.getElementById('card_form');
            form.submit();
        }

        // Apply syncing for both Background and Text color
        syncColor("bg-color-picker", "bg-hex");
        syncColor("text-color-picker", "text-hex");
    </script>
@endsection
