@extends('schoolLayout.app')
@section('content')
    @if (session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
        <div class="p-6 w-full bg-white rounded-lg shadow-sm flex justify-between items-center">
            <!-- Left Section: Profile Image + Student Info -->
            <div class="flex w-[30%] items-center gap-x-4">
                <img src="{{ $student->documents && $student->documents->photo ? asset('storage/' . $student->documents->photo) : asset('assets/sidebar/student.png') }}"
                    alt="Student Profile" class="w-28 h-28 rounded-full object-cover border" />
                <div>
                    <h2 class="text-xl font-bold">{{ $student->student_name }}</h2>
                    <p class="text-gray-500">Roll No: #{{ $student->latestAdmission->roll_number }}</p>
                    <p class="text-gray-600">Class:
                        {{ $student->classes->first()->name }}-{{ $student->sections->first()->name }}</p>
                </div>
            </div>

            <!-- Right Section: Buttons -->
            <div class="w-[70%] grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 p-4">
                <!-- Card 1 -->
                <div class="flex justify-between items-center bg-[#f0fdf4] text-[#15803D] px-4 py-2 shadow-sm rounded-lg">
                    <div class="w-[70%]">
                        <p class="font-semibold">Present Days</p>
                        <p class="font-bold text-xl">{{ $presentCount }}</p>
                        <p class="mt-1">{{ $presentPercent }}%</p>
                    </div>
                    <i class="fa-solid fa-circle-check text-[#22C55E] text-2xl"></i>
                </div>

                <!-- Card 2 -->
                <div class="flex justify-between items-center bg-[#fef2f2] text-[#DC2626] px-4 py-2 shadow-sm rounded-lg">
                    <div class="w-[70%]">
                        <p class="font-semibold">Absent Days</p>
                        <p class="font-bold text-xl">{{ $absentCount }}</p>
                        <p class="mt-1">{{ $absentPercent }}%</p>
                    </div>
                    <i class="fa-solid fa-circle-xmark text-[#EF4444] text-2xl"></i>
                </div>

                <!-- Card 3 -->
                <div class="flex justify-between items-center bg-[#eff6ff] text-[#3B82F6] px-4 py-2 shadow-sm rounded-lg">
                    <div class="w-[70%]">
                        <p class="font-semibold">Leaves</p>
                        <p class="font-bold text-xl">{{ $leaveCount }}</p>
                        <p class="mt-1">{{ $leavePercent }}%</p>
                    </div>
                    <i class="fa-solid fa-calendar text-[#3B82F6] text-3xl"></i>
                </div>

                <!-- Card 4 -->

                <div class="flex justify-between items-center bg-[#fefbe8] text-[#CA8A04] px-4 py-2 shadow-sm rounded-lg">
                    <div class="w-[70%]">
                        <p class="font-semibold">Half Days</p>
                        <p class="font-bold text-xl">{{ $halfDayCount }}</p>
                        <p class="mt-1">{{ $halfDayPercent }}%</p>
                    </div>
                    <i class="fa-solid fa-circle-half-stroke text-[#EAB308] text-3xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white shadow-sm mt-10 rounded-lg">
            <div class="flex justify-between items-center p-4 s">
                <!-- Left: Search Input with Icon -->
                <div class="relative w-1/3">
                    <!-- <i
                  class="fa-solid fa-magnifying-glass absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"
                ></i>
                <input
                  type="text"
                  placeholder="Search..."
                  class="pl-10 pr-4 py-2 w-full border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                /> -->
                </div>

                <!-- Right: Date Range + Year/Month/Week Select -->
                <div class="flex items-center space-x-4">
                    <!-- Date Range -->
                    <div class="relative">
                        <!--  <i
                    class="fa-solid fa-calendar-days absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"
                  ></i>
                  <input
                    type="date"
                    class="pl-10 pr-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                  /> -->
                        <form action="{{ route('attendance.show', $student->id) }}" method="GET">
                            <select name="year"
                                class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                @php
                                    $currentYear = now()->year;
                                @endphp

                                <option disabled selected>Year</option>
                                @for ($i = 0; $i < 4; $i++)
                                    <option value="{{ $currentYear - $i }}">{{ $currentYear - $i }}</option>
                                @endfor

                            </select>

                            <select name="month"
                                class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option disabled selected>Month</option>
                                @php
                                    $months = [
                                        'January',
                                        'February',
                                        'March',
                                        'April',
                                        'May',
                                        'June',
                                        'July',
                                        'August',
                                        'September',
                                        'October',
                                        'November',
                                        'December',
                                    ];
                                @endphp
                                @foreach ($months as $index => $month)
                                    <option value="{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}">{{ $month }}
                                    </option>
                                @endforeach

                            </select>


                            <button class="bg-[#0197FF] text-white px-6 py-2 rounded-sm hover:bg-blue-600">
                                Apply Filters
                            </button>
                        </form>
                    </div>

                    <!-- Select Inputs -->



                </div>
            </div>
            <div class="mt-4">
                <table class="w-full bg-white border-gray-300">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-left text-gray-800 font-medium">
                            <th class="p-3  text-gray-600 font-medium">
                                Date
                            </th>
                            <th class="p-3 text-gray-600 font-medium">
                                Status
                            </th>
                            <th class="p-3  text-gray-600 font-medium">
                                Remarks
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Row 1 -->
                        @foreach ($attendanceRecords as $record)
                            <tr class="border-b">
                                <td class="p-3 text-gray-600">{{ \Carbon\Carbon::parse($record->date)->format('M d, Y') }}
                                </td>
                                <td class="p-3 text-gray-600">
                                    @php
                                        $status = strtolower($record->status);
                                        $statusDisplay = ucfirst(str_replace('_', ' ', $status));

                                        // Assign styles based on status
                                        $badgeStyles = match ($status) {
                                            'present' => ['bg' => '#DCFCE7', 'text' => '#166534'],
                                            'absent' => ['bg' => '#FEE2E2', 'text' => '#991B1B'],
                                            'leave' => ['bg' => '#DBEAFE', 'text' => '#1E40AF'],
                                            'half_day' => ['bg' => '#FEF9C3', 'text' => '#854D0E'],
                                            default => ['bg' => '#E5E7EB', 'text' => '#374151'],
                                        };
                                    @endphp

                                    <span class="font-semibold px-2 py-0.5 rounded-2xl text-sm"
                                        style="background-color: {{ $badgeStyles['bg'] }}; color: {{ $badgeStyles['text'] }};">
                                        {{ $statusDisplay }}
                                    </span>
                                </td>
                                <td class="p-3 text-gray-600">
                                    {{ $record->remarks ?? '-' }}
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
                <div class="flex bg-white mt-10 border-t border-gray-200 justify-between items-center p-4">
                    <div class="flex justify-between items-center mt-4">

                    </div>

                    <div class="flex space-x-2">
                        {{-- {{ $attendanceRecords->links('vendor.pagination.custom-pagination') }} --}}

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
@endsection
