@extends('schoolLayout.app')
@section('content')
    @if (session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error:</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success:</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    <div class="bg-[#f9fafc] min-h-screen px-8 py-8">
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-4 w-full border-b border-gray-200 mb-8">
                <button onclick="window.location.href='{{ route('show.attendance') }}'"
                    class="tab-btn pb-3 text-gray-700 font-semibold">
                    Student Attendance
                </button>
                <button onclick="window.location.href='{{ route('attendance.report') }}'"
                    class="tab-btn px-4 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Attendance Report
                </button>
            </div>
        </div>

        <form method="GET" action="{{ route('attendance.report') }}">

            <div class="flex justify-between items-center bg-white p-4 shadow-sm rounded-lg">
                <!-- Left Side - Select Inputs -->

                <div class="flex gap-4">

                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Year</label>
                        <select required name="year" class="border p-2 min-w-[100px] rounded-lg">
                            <option disabled selected>Year</option>
                            @for ($y = now()->year; $y >= now()->year - 3; $y--)
                                <option value="{{ $y }}" {{ request('year') == $y ? 'selected' : '' }}>
                                    {{ $y }}</option>
                            @endfor
                        </select>
                    </div>

                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Month</label>
                        <select required name="month" class="border p-2 min-w-[100px] rounded-lg">
                            <option disabled selected>Month</option>
                            @for ($m = 1; $m <= 12; $m++)
                                <option value="{{ str_pad($m, 2, '0', STR_PAD_LEFT) }}"
                                    {{ request('month') == str_pad($m, 2, '0', STR_PAD_LEFT) ? 'selected' : '' }}>
                                    {{ \Carbon\Carbon::create()->month($m)->format('F') }}
                                </option>
                            @endfor
                        </select>
                    </div>


                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Class</label>
                        <select required name="class_id" class="border p-2 min-w-[100px] rounded-lg">
                            <option value="">Select Class</option>
                            @foreach ($classes as $class)
                                <option value="{{ $class->id }}"
                                    {{ request('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="flex flex-col">
                        <label class="text-gray-700 text-sm font-medium mb-1">Section</label>
                        <select name="section_id" class="border p-2 min-w-[150px] rounded-sm">
                            <option value="">Select Section</option>
                            @foreach ($sections as $section)
                                <option value="{{ $section->id }}"
                                    {{ request('section_id') == $section->id ? 'selected' : '' }}>
                                    Section {{ $section->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                </div>

                <!-- Right Side - Buttons -->
                <div class="flex gap-2">
                    <button class="bg-[#0197FF] text-white px-6 py-2 rounded-sm hover:bg-blue-600">
                        Apply Filters
                    </button>
                    <button class="bg-white border border-gray-400 text-gray-700 px-6 py-2 rounded-sm font-medium">
                        Reset
                    </button>
                </div>

            </div>
        </form>
        <div class="mt-4 bg-white shadow-sm rounded-lg">
            <div class="flex justify-between items-center p-4">
                <!-- Left Side - Heading -->
                <h2 class="text-lg font-semibold text-gray-700">Detailed Report</h2>

                <!-- Right Side - Buttons -->
                <div class="flex gap-2">
                    <!-- <button
                  class="flex items-center gap-2 border border-gray-400 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-100"
                >
                <a href="{{ request()->fullUrlWithQuery(['export' => 'excel']) }}" class="btn btn-outline-success">
                    <i class="fa fa-file-excel"></i> Export Excel
                </a>
                </button> -->
                    <button
                        class="flex items-center gap-2 border border-gray-400 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-100">
                        <a href="{{ request()->fullUrlWithQuery(['export' => 'pdf']) }}" class="btn btn-outline-danger">
                            <i class="fa fa-file-pdf"></i> Export PDF
                        </a>
                    </button>
                </div>
            </div>
            <div class="mt-4">
                <table class="w-full bg-white border-gray-300">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-left text-gray-800 font-medium">
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Student
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Roll No
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">Class</th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Present
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Absent
                            </th>
                            <th class="p-3 text-center text-gray-600 font-medium">Leave</th>
                            <th class="p-3 text-center text-gray-600 font-medium">
                                Attendance %
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Row 1 -->
                        @foreach ($students as $student)
                            <tr class="border-b">
                                <td class="p-3 justify-center flex items-center space-x-3">
                                    <img src="{{ $student->documents && $student->documents->photo ? asset('storage/' . $student->documents->photo) : asset('assets/sidebar/student.png') }}"
                                        alt="Student" class="w-10 h-10 rounded-full" />
                                    <p class="font-medium">{{ $student->student_name }}</p>
                                </td>
                                <td class="p-3 text-center text-gray-600"> {{ $student->latestAdmission->roll_number }}
                                </td>
                                <td class="p-3 text-center text-gray-600">{{ $student->classes->first()->name }} -
                                    Section-{{ $student->sections->first()->name }}</td>
                                <td class="p-3 text-center text-gray-600">{{ $student->present_count }}</td>
                                <td class="p-3 text-center text-gray-600">{{ $student->absent_count }}</td>
                                <td class="p-3 text-center text-gray-600">{{ $student->leave_count }}</td>
                                <td class="p-3 text-center text-gray-600">
                                    <span class="bg-[#DCFCE7] text-[#166534] px-2 py-0.5 rounded-2xl text-sm">
                                        @php
                                            $present = $student->present_count ?? 0;
                                            $total = $student->total_attendance_count ?? 0;
                                            $percent = $total > 0 ? round(($present / $total) * 100, 1) : 0;
                                        @endphp

                                        {{ $percent }}%

                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="flex bg-white mt-10 border-t border-gray-200 justify-between items-center p-4">
                    <div class="flex justify-between items-center mt-4">

                    </div>

                    <div class="flex space-x-2">
                        {{ $students->links('vendor.pagination.custom-pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
@endsection
