<!DOCTYPE html>
<html>
<head>
    <title>Attendance PDF</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f2f2f2; }
    </style>
</head>
<body>
    <h3>Attendance Report</h3>
    <table>
        <thead>
            <tr>
                <th>Student</th>
                <th>Roll No</th>
                <th>Class</th>
                <th>Present</th>
                <th>Absent</th>
                <th>Leave</th>
                <th>Attendance %</th>
            </tr>
        </thead>
        <tbody>
            @foreach($students as $student)
            <tr>
                <td>{{ $student->student_name }}</td>
                <td>{{ $student->latestAdmission->roll_number }}</td>
                <td>{{ $student->latestAdmission->class->name ?? '-' }} - {{ $student->latestAdmission->section->name ?? '-' }}</td>
                <td>{{ $student->present_count }}</td>
                <td>{{ $student->absent_count }}</td>
                <td>{{ $student->leave_count }}</td>
                <td>
                    @php
                        $total = $student->total_attendance_count;
                        $present = $student->present_count;
                        $percentage = $total > 0 ? round(($present / $total) * 100) . '%' : '0%';
                    @endphp
                    {{ $percentage }}
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
