<table>
    <thead>
        <tr>
            <th>Student</th>
            <th>Roll No</th>
            <th>Class</th>
            <th>Present</th>
            <th>Absent</th>
            <th>Leave</th>
            <th>Attendance %</th>
        </tr>
    </thead>
    <tbody>
        @foreach($students as $student)
        <tr>
            <td>{{ $student->name }}</td>
            <td>{{ $student->roll_number }}</td>
            <td>{{ $student->latestAdmission->class->name ?? '-' }} - {{ $student->latestAdmission->section->name ?? '-' }}</td>
            <td>{{ $student->present_count }}</td>
            <td>{{ $student->absent_count }}</td>
            <td>{{ $student->leave_count }}</td>
            <td>
                @php
                    $total = $student->total_attendance_count;
                    $present = $student->present_count;
                    $percentage = $total > 0 ? round(($present / $total) * 100) . '%' : '0%';
                @endphp
                {{ $percentage }}
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
