@extends('schoolLayout.app')

@section('content')
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
        <div class="p-6 w-full bg-white rounded-lg shadow-sm flex justify-between items-center">
            <!-- Left Section: Profile Image + Student Info -->
            <div class="flex items-center gap-x-4">
                {{--                 <img src="{{ asset('storage/' . $student->documents->photo) }}" alt="Student Profile"
                    class="w-28 h-28 rounded-full object-cover border" /> --}}
                <div>
                    <h2 class="text-xl font-bold">{{ $student->full_name }}</h2>
                    <p class="text-gray-500 mb-2">{{ $student->father_name }}</p>
                    <p class="text-gray-500 mb-2">{{ $student->dob }}</p>
                </div>
            </div>
        </div>


        <!-- Information Cards -->
        <div class="grid grid-cols-1 mt-4 rounded-lg bg-[#f9fafc] md:grid-cols-2 gap-6 w-full">
            <!-- Admission Information Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">Detail</h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">CNIC</span>
                        <span class="text-black font-semibold">{{ $student->cnic }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Application Date</span>
                        <span class="text-black font-semibold">
                            {{ \Carbon\Carbon::parse($student->created_at)->format('d F, Y') }}
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Class To Apply</span>
                        <span class="text-black font-semibold">{{ $student->classes->first()->name }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Address</span>
                        <span class="text-black font-semibold"> {{ $student->address }} </span>
                    </div>
                </div>
            </div>

            <!-- Personal Information Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">Personal Information</h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Date of Birth</span>
                        <span
                            class="text-black font-semibold">{{ \Carbon\Carbon::parse($student->dob)->format('d F, Y') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Gender</span>
                        <span class="text-black font-semibold">{{ $student->gender }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Nationality</span>
                        <span class="text-black font-semibold">Pakistani</span>
                    </div>
                </div>
            </div>

            <!-- Guardian & Emergency Contact Card -->
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-lg font-semibold mb-4">
                    Guardian & Emergency Contact
                </h2>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Guardian Name</span>
                        <span
                            class="text-black font-semibold">{{ $student->NewStudentApplicationGuardian->guardian_name ?? 'N/A' }}
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Guardian Relation</span>
                        <span
                            class="text-black font-semibold">{{ $student->NewStudentApplicationGuardian->guardian_relationship ?? 'N/A' }}
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Guardian Contact</span>
                        <span
                            class="text-black font-semibold">{{ $student->NewStudentApplicationGuardian->primary_contact ?? 'N/A' }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Emergency Contact</span>
                        <span
                            class="text-black font-semibold">{{ $student->NewStudentApplicationGuardian->alternate_contact ?? 'N/A' }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
