<!DOCTYPE html>
<html>
<head>
    <title>Student Applications</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 6px; text-align: left; }
        th { background-color: #f0f0f0; }
    </style>
</head>
<body>
    <h2>Student Applications</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Full Name</th>
                <th>CNIC</th>
                <th>Class</th>
                <th>Guardian Contact</th>
                <th>DOB</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($students as $index => $student)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $student->full_name }}</td>
                    <td>{{ $student->cnic }}</td>
                    <td>{{ optional($student->classes)->name ?? '-' }}</td>
                    <td>{{ $student->NewStudentApplicationGuardian->primary_contact ?? 'N/A' }}</td>
                    <td>{{ $student->dob }}</td>
                    <td>
                        @if ($student->status == '1')
                            Pending
                        @elseif ($student->status == '2')
                            Accepted
                        @elseif ($student->status == '3')
                            Rejected
                        @else
                            {{ $student->status }}
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
