@extends('schoolLayout.app')
@section('content')
    <div class="bg-white p-6 rounded-lg shadow-md w-full">
        <h2 class="text-2xl font-semibold text-gray-800 mb-4">
            New Student Application
        </h2>
        @include('successError')
        <form action="{{ route('submit.application') }}" method="POST" class="space-y-4" id="studentApplicationForm">
            @csrf
            <!-- Student Information -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Full Name</label>
                    <input type="text" name="full_name" value="{{ old('full_name') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('full_name') border-red-500 @enderror" />
                    @error('full_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-gray-700">Father Name</label>
                    <input type="text" name="father_name" value="{{ old('father_name') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('father_name') border-red-500 @enderror" />
                    @error('father_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Date of Birth</label>
                    <input type="date" name="dob" value="{{ old('dob') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('dob') border-red-500 @enderror" />
                    @error('dob')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-gray-700">Gender</label>
                    <select name="gender"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('gender') border-red-500 @enderror">
                        <option value="">Select Gender</option>
                        <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                        <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                        <option value="Other" {{ old('gender') == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>
                    @error('gender')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">CNIC/B-Form Number</label>
                    <input type="text" name="cnic" value="{{ old('cnic') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500
                        @error('cnic') border-red-500 @enderror" />
                    @error('cnic')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-gray-700">Class Applying For</label>
                    <select name="class_applying"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500
                        @error('class_applying') border-red-500 @enderror">
                        <option value="">Select Class</option>
                        @if ($classes)
                            @foreach ($classes as $class)
                                <option value="{{ $class->id }}"
                                    {{ old('class_applying') == $class->name ? 'selected' : '' }}>
                                    {{ $class->name }}</option>
                            @endforeach
                        @endif
                    </select>
                    @error('class_applying')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <h3 class="text-lg font-semibold text-gray-800 mt-4">
                Parent/Guardian Information
            </h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Guardian's Full Name</label>
                    <input type="text" name="guardian_name" value="{{ old('guardian_name') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500
                        @error('guardian_name') border-red-500 @enderror" />
                    @error('guardian_name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-gray-700">Relationship to Student</label>
                    <select name="guardian_relationship"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('guardian_relationship') border-red-500 @enderror">
                        <option value="">Select Relationship</option>
                        <option value="Father" {{ old('guardian_relationship') == 'Father' ? 'selected' : '' }}>Father
                        </option>
                        <option value="Mother" {{ old('guardian_relationship') == 'Mother' ? 'selected' : '' }}>Mother
                        </option>
                        <option value="Guardian" {{ old('guardian_relationship') == 'Guardian' ? 'selected' : '' }}>
                            Guardian</option>
                    </select>
                    @error('guardian_relationship')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Guardian's CNIC Number</label>
                    <input type="text" name="guardian_cnic" value="{{ old('guardian_cnic') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('guardian_cnic') border-red-500 @enderror" />
                    @error('guardian_cnic')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-gray-700">Primary Contact Number</label>
                    <input type="text" name="primary_contact" value="{{ old('primary_contact') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                        @error('primary_contact') border-red-500 @enderror" />
                    @error('primary_contact')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700">Alternate Contact Number</label>
                    <input type="text" name="alternate_contact"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500" />
                </div>
                <div>
                    <label class="block text-gray-700">Email Address</label>
                    <input type="text" name="email" value="{{ old('email') }}"
                        class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500 
                  " />
                </div>
            </div>

            <div>
                <label class="block text-gray-700">Home Address</label>
                <textarea name="address"
                    class="w-full p-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500
                    @error('address') border-red-500 @enderror"
                    rows="3">{{ old('address') }}</textarea>
                @error('address')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit Button -->
            <div class="mt-4 flex justify-end">
                <button type="submit" class="px-4 bg-blue-600 text-white py-2 rounded-md hover:bg-blue-700">
                    Submit Application
                </button>
            </div>
        </form>
    </div>
    <!-- Include jQuery & jQuery Validation Plugin -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#studentApplicationForm").validate({
                rules: {
                    full_name: {
                        required: true,
                        minlength: 3
                    },
                    father_name: {
                        required: true,
                        minlength: 3
                    },
                    dob: {
                        required: true,
                        date: true
                    },
                    gender: {
                        required: true
                    },
                    cnic: {
                        required: true,
                        digits: true,
                        minlength: 13,
                        maxlength: 13
                    },
                    class_applying: {
                        required: true
                    },
                    guardian_name: {
                        required: true,
                        minlength: 3
                    },
                    guardian_relationship: {
                        required: true
                    },
                    guardian_cnic: {
                        required: true,
                        digits: true,
                        minlength: 13,
                        maxlength: 13
                    },
                    primary_contact: {
                        required: true,
                        digits: true,
                        minlength: 11,
                        maxlength: 11
                    },
                    alternate_contact: {
                        digits: true,
                        minlength: 11,
                        maxlength: 11
                    },
                    email: {
                        required: true,
                        email: true
                    },
                    address: {
                        required: true
                    }
                },
                messages: {
                    full_name: "Please enter your full name (min 3 characters).",
                    father_name: "Please enter the father's name (min 3 characters).",
                    dob: "Please enter a valid date of birth.",
                    gender: "Please select a gender.",
                    cnic: "Please enter a valid 13-digit CNIC/B-Form number.",
                    class_applying: "Please select a class.",
                    guardian_name: "Please enter the guardian's full name.",
                    guardian_relationship: "Please select the guardian's relationship.",
                    guardian_cnic: "Please enter a valid 13-digit CNIC.",
                    primary_contact: "Please enter a valid 11-digit phone number.",
                    alternate_contact: "Please enter a valid 11-digit phone number.",
                    email: "Please enter a valid email address.",
                    address: "Please enter your home address."
                },
                errorPlacement: function(error, element) {
                    error.addClass("text-red-500 text-sm");
                    error.insertAfter(element);
                }
            });
        });
    </script>
@endsection
