@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 38px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <!-- Header Section -->
    <div class="flex justify-between items-center">
        <div class="flex flex-col">
            <h1 class="text-2xl font-bold text-gray-800">Student Application</h1>
        </div>
        <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg"
            onclick="window.location.href='{{ route('student.application.form') }}'">
            <img src="{{ asset('assets/new.png') }}" alt="icon" />
            <span>New Application</span>
        </button>
    </div>
    <div class="flex  w-full bg-white">
        <button
            class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
            All
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl">{{ $allCount ?? 'N/A' }}</span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Pending
            <span class="bg-gray-200 px-4 py-1 text-gray-700 text-sm rounded-2xl">{{ $pending ?? 'N/A' }}</span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Accepted
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl">{{ $accept ?? 'N/A' }}</span>
        </button>
        <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
            Rejected
            <span class="bg-gray-200 px-4 py-1 text-red-700 text-sm rounded-2xl">{{ $reject ?? 'N/A' }}</span>
        </button>
    </div>
    <div class="flex items-center mt-4 space-x-4">
        <input type="text" id="student-search" placeholder="Search by student name..."
            class="w-full p-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" />

        <select id="class_filter" name="class_filter" class="border p-2 rounded-lg  select2 custom-select2">
            <option value="">All Classes</option>
            @foreach ($class as $class)
                <option value="{{ $class->id }}">
                    {{ $class->name }}
                </option>
            @endforeach
        </select>
        <button class="bg-blue-500 px-4 py-2 text-white rounded-lg" onclick="downloadFilteredPDF()">
            <span>PDF</span>
        </button>
    </div>
    <!-- Applications Table -->
    <div class="bg-white py-3 rounded-lg shadow mt-6 relative">
        <!-- 🔁 Container for results -->
        <div id="student-table" class="bg-white py-3 rounded-lg shadow mt-6 relative">
            @include('stdApplication.partialApp', ['students' => $students])
        </div>
    </div>
    <div class="flex justify-between items-center px-4 pt-4 border-t border-gray-200 mt-8">
        <div class="flex items-center text-sm text-gray-500">
            Showing {{ $students->firstItem() }} to {{ $students->lastItem() }} of {{ $students->total() }} results

            <form method="GET" class="ml-3">
                <select name="entries" onchange="this.form.submit()"
                    class="border rounded-lg px-1 py-1 text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                    <option value="10" {{ request('entries') == 10 ? 'selected' : '' }}>10</option>
                    <option value="20" {{ request('entries') == 20 ? 'selected' : '' }}>20</option>
                    <option value="30" {{ request('entries') == 30 ? 'selected' : '' }}>30</option>
                </select>
            </form>
        </div>

        <div class="mt-2">
            {{ $students->appends(request()->query())->onEachSide(1)->links('pagination::tailwind') }}

        </div>

    </div>
    <script>
        function downloadFilteredPDF() {
            let classFilter = document.getElementById('class_filter').value;
            let url = "{{ route('pdf.student.application.all') }}";

            if (classFilter) {
                url += '?class_filter=' + classFilter;
            }

            window.location.href = url;
        }
    </script>

    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: "Select Class",
                allowClear: true,
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });

        $(document).on('click', '.pagination a', function(event) {
            event.preventDefault();
            let url = $(this).attr('href');

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });
    </script>

    <script>
        $('#student-search').on('keyup', function() {
            let query = $(this).val();

            $.ajax({
                url: "{{ route('student.application') }}",
                type: "GET",
                data: {
                    search: query
                },
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });

        $('#class_filter').on('change', function() {
            let selectedClassId = $(this).val();

            $.ajax({
                url: "{{ route('student.application') }}",
                type: "GET",
                data: {
                    class_search: selectedClassId // Send the selected class ID as data
                },
                success: function(data) {
                    $('#student-table').html(data);
                }
            });
        });

        function updateStatus(id, status) {
            fetch(`/std/app/status/${id}`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}', // Ensure CSRF token is passed
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        status: status
                    }) // Sending the status value
                })
                .then(response => response.json()) // Handling JSON response
                .then(data => {
                    if (data.success) {
                        // Update the status on the page
                        const statusElement = document.querySelector(`#status-${id}`);
                        let displayText = data.status;

                        // Optionally, add a class for styling the status and update display text
                        statusElement.classList.remove('bg-green-200', 'text-green-700', 'bg-red-200', 'text-red-700',
                            'bg-yellow-200', 'text-yellow-700');

                        if (data.status === '1') {
                            statusElement.classList.add('bg-yellow-200', 'text-yellow-700');
                            displayText = 'Pending';
                        } else if (data.status === '2') {
                            statusElement.classList.add('bg-green-200', 'text-green-700');
                            displayText = 'Accepted';
                        } else if (data.status === '3') {
                            statusElement.classList.add('bg-red-200', 'text-red-700');
                            displayText = 'Rejected';
                        }

                        statusElement.textContent = displayText;
                    }
                })
                .catch(error => console.error('Error:', error));
        }
    </script>
    <script>
        function toggleDropdown(button) {
            // Close all dropdowns first
            document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                if (dropdown !== button.nextElementSibling) {
                    dropdown.classList.add("hidden");
                }
            });

            // Toggle the clicked dropdown
            const dropdown = button.nextElementSibling;
            dropdown.classList.toggle("hidden");
        }

        // Close dropdown when clicking outside
        document.addEventListener("click", function(event) {
            if (!event.target.closest(".action-btn")) {
                document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
                    dropdown.classList.add("hidden");
                });
            }
        });
    </script>
@endsection
