@extends('schoolLayout.app')
@section('content')
    <div class="bg-white p-6 rounded-xl">
        <!-- Header Section -->
        <div class="flex justify-between items-center">
            <div class="flex flex-col">
                <h1 class="text-2xl font-bold text-gray-800">Student Documents</h1>
            </div>
        </div>

        <div class="flex justify-between border-t border-b border-gray-200 my-4 w-full bg-white">
            <div class="flex">
                <button
                    class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Student ID Cards
                </button>
                <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
                    Admission Letters
                </button>
                <button class="tab-btn flex items-center gap-x-4 px-4 bg-white py-2 font-semibold text-gray-600">
                    Certificates
                </button>
            </div>
            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-lg">
                <span>Costomise</span>
            </button>
        </div>
        <!-- Search and Filters -->
        <div class="flex flex-col md:flex-row justify-between items-center gap-4 bg-white p-4">
            <!-- Search Input -->
            <div class="relative w-full md:w-1/2">
                <div class="border border-gray-300 rounded-md bg-white flex items-center px-4 py-2">
                    <img src="{{ asset('assets/search.png') }}" alt="Search" class="w-5 h-5 text-gray-500" />
                    <input type="text" placeholder="Search by name, admission ID, or grade..."
                        class="w-full pl-3 text-sm border-none focus:outline-none" />
                </div>
            </div>

            <!-- Filters & Print Button -->
            <div class="flex flex-wrap gap-3 w-full md:w-auto items-center">
                <select class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400">
                    <option>All Grades</option>
                </select>
                <select class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400">
                    <option>All Classes</option>
                </select>
                <select class="p-2 border border-gray-300 rounded-md text-sm focus:ring-2 focus:ring-blue-400">
                    <option>Sort By</option>
                </select>

                <!-- Print Button -->
                <button class="p-2 border border-gray-200 rounded-md flex items-center gap-2 hover:bg-blue-600 transition">
                    <i class="fa-solid fa-print"></i>
                    Print Selected
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 p-6">
            <!-- Student Card 1 -->
            <div class="bg-white shadow-lg rounded-lg p-4 flex flex-col items-center border border-gray-200">
                <img src="{{ asset('assets/fourth.png') }}" alt="Student Image" class="w-24 h-24 rounded-full mb-1">
                <p class="text-lg font-semibold text-gray-800 mb-1">Michael Brown</p>
                <p class="text-sm text-gray-500"> Admission Date: Aug 25</p>
                <p class="text-sm text-gray-500"> Contact: +1 456 789 012</p>
                <p class="text-sm text-gray-500"> Grade: 12, Class: C</p>
                <button class="mt-3 bg-[#0197FF] text-white px-4 py-2 rounded-sm hover:bg-blue-700">
                    View Details
                </button>
            </div>

            <!-- Student Card 2 -->
            <div class="bg-white shadow-lg rounded-lg p-4 flex flex-col items-center border border-gray-200">
                <img src="{{ asset('assets/fifth.png') }}" alt="Student Image" class="w-24 h-24 rounded-full mb-1">
                <p class="text-lg font-semibold text-gray-800 mb-1">Michael Brown</p>
                <p class="text-sm text-gray-500"> Admission Date: Aug 25</p>
                <p class="text-sm text-gray-500"> Contact: +1 456 789 012</p>
                <p class="text-sm text-gray-500"> Grade: 12, Class: C</p>
                <button class="mt-3 bg-[#0197FF] text-white px-4 py-2 rounded-sm hover:bg-blue-700">
                    View Details
                </button>
            </div>

            <!-- Student Card 3 -->
            <div class="bg-white shadow-lg rounded-lg p-4 flex flex-col items-center border border-gray-200">
                <img src="{{ asset('assets/sixth.png') }}" alt="Student Image" class="w-24 h-24 rounded-full mb-1">
                <p class="text-lg font-semibold text-gray-800 mb-1">Michael Brown</p>
                <p class="text-sm text-gray-500"> Admission Date: Aug 25</p>
                <p class="text-sm text-gray-500"> Contact: +1 456 789 012</p>
                <p class="text-sm text-gray-500"> Grade: 12, Class: C</p>
                <button class="mt-3 bg-[#0197FF] text-white px-4 py-2 rounded-sm hover:bg-blue-700">
                    View Details
                </button>
            </div>


        </div>

    </div>
@endsection
