@extends('schoolLayout.app')
@section('content')
@include('successError')
   
    <div class="px-6 py-6 bg-[#f9fafc] min-h-screen">
      <div
        class="p-6 w-full bg-white rounded-lg shadow-sm flex justify-between items-center"
      >
        <div class="flex w-[30%] items-center gap-x-4">
          <img
            src="{{ $staff  && $staff->profile_photo ?  url('/staff-members/' . $staff->profile_photo)  : asset('assets/sidebar/student.png') }}"
            alt="Student Profile"
            class="w-28 h-28 rounded-full object-cover border"
          />
          <div>
 

            <h2 class="text-xl font-bold">{{ $staff->full_name }}</h2>
            <p class="text-gray-500">Employee ID: {{ $staff->registration_no }}</p>
           </div>
        </div>

        <!-- Right Section: Buttons -->
        <div
          class="w-[70%] grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 p-4"
        >
          <!-- Card 1 -->
          <div
            class="flex justify-between items-center bg-[#f0fdf4] text-[#15803D] px-4 py-2 shadow-sm rounded-lg"
          >
            <div class="w-[70%]">
              <p class="font-semibold">Present Days</p>
              <p class="font-bold text-xl">{{$presentCount}}</p>
              <p class="mt-1">{{$presentPercent}}%</p>
            </div>
            <i class="fa-solid fa-circle-check text-[#22C55E] text-2xl"></i>
          </div>

          <!-- Card 2 -->
          <div
            class="flex justify-between items-center bg-[#fef2f2] text-[#DC2626] px-4 py-2 shadow-sm rounded-lg"
          >
            <div class="w-[70%]">
              <p class="font-semibold">Absent Days</p>
              <p class="font-bold text-xl">{{$absentCount}}</p>
              <p class="mt-1">{{$absentPercent}}%</p>
            </div>
            <i class="fa-solid fa-circle-xmark text-[#EF4444] text-2xl"></i>
          </div>

          <!-- Card 3 -->
          <div
            class="flex justify-between items-center bg-[#eff6ff] text-[#3B82F6] px-4 py-2 shadow-sm rounded-lg"
          >
            <div class="w-[70%]">
              <p class="font-semibold">Leaves</p>
              <p class="font-bold text-xl">{{$leaveCount}}</p>
              <p class="mt-1">{{$leavePercent}}%</p>
            </div>
            <i class="fa-solid fa-calendar text-[#3B82F6] text-3xl"></i>
          </div>

          <!-- Card 4 -->

          <div
            class="flex justify-between items-center bg-[#fefbe8] text-[#CA8A04] px-4 py-2 shadow-sm rounded-lg"
          >
            <div class="w-[70%]">
              <p class="font-semibold">Half Days</p>
              <p class="font-bold text-xl">{{$halfDayCount}}</p>
              <p class="mt-1">{{$halfDayPercent}}%</p>
            </div>
            <i
              class="fa-solid fa-circle-half-stroke text-[#EAB308] text-3xl"
            ></i>
          </div>
        </div>
      </div>

      <div class="bg-white shadow-sm mt-10 rounded-lg">
        <div class="flex justify-between items-center p-4 s">
          <!-- Left: Search Input with Icon -->
          <div class="relative w-1/3">
            <!-- <i
              class="fa-solid fa-magnifying-glass absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"
            ></i>
            <input
              type="text"
              placeholder="Search Staff..."
              class="pl-10 pr-4 py-2 w-full border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
            /> -->
          </div>

          <!-- Right: Date Range + Year/Month/Week Select -->
          <div class="flex items-center space-x-4">
            <!-- Date Range -->
            <div class="relative">
             <!--  <i
                class="fa-solid fa-calendar-days absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"
              ></i>
              <input
                type="date"
                class="pl-10 pr-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
              /> -->
            </div>

            <!-- Select Inputs -->
            <form action="{{ route('staff.attend.show', $staff->id) }}" method="GET">
                            <select name="year"
                                class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                @php
                                    $currentYear = now()->year;
                                @endphp

                                <option disabled selected>Year</option>
                                @for ($i = 0; $i < 4; $i++)
                                    <option value="{{ $currentYear - $i }}">{{ $currentYear - $i }}</option>
                                @endfor

                            </select>

                            <select name="month"
                                class="px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option disabled selected>Month</option>
                                @php
                                    $months = [
                                        'January',
                                        'February',
                                        'March',
                                        'April',
                                        'May',
                                        'June',
                                        'July',
                                        'August',
                                        'September',
                                        'October',
                                        'November',
                                        'December',
                                    ];
                                @endphp
                                @foreach ($months as $index => $month)
                                    <option value="{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}">{{ $month }}
                                    </option>
                                @endforeach

                            </select>


                            <button class="bg-[#0197FF] text-white px-6 py-2 rounded-sm hover:bg-blue-600">
                                Apply Filters
                            </button>
                        </form>
          </div>
        </div>
        <div class="mt-4">
          <table class="w-full bg-white border-gray-300">
            <thead class="bg-[#f9fafc]">
              <tr class="text-left text-gray-800 font-medium">
                <th class="p-3 text-gray-500 font-medium">Date</th>
                <th class="p-3 text-gray-500 font-medium">Check-in Time</th>
                <th class="p-3 text-gray-500 font-medium">Check-out Time</th>
                <th class="p-3 text-gray-500 font-medium">Work Duration</th>
                <th class="p-3 text-gray-500 font-medium">Status</th>
                <th class="p-3 text-gray-500 font-medium">Remarks</th>
              </tr>
            </thead>
            <tbody>
              <!-- Row 1 -->
              @foreach ($attendanceRecords as $record)
              <tr class="border-b">
                <td class="p-3 text-gray-800">{{ \Carbon\Carbon::parse($record->date)->format('M d, Y') }}</td>
                <td class="p-3 text-gray-600">{{ $record->check_in ? \Carbon\Carbon::parse($record->check_in)->format('h:i A') : 'N/A' }}
                <td class="p-3 text-gray-600">{{ $record->check_out ? \Carbon\Carbon::parse($record->check_out)->format('h:i A') : 'N/A' }}
</td>                <td class="p-3 text-gray-600">
                    @if($record->check_in && $record->check_out)
                    @php
                        $checkIn = \Carbon\Carbon::parse($record->check_in);
                        $checkOut = \Carbon\Carbon::parse($record->check_out);
                        $diff = $checkIn->diff($checkOut);
                        @endphp
                        {{ $diff->h }}h {{ $diff->i }}m
                    @else
                        N/A
                     @endif
                </td>
                <td class="p-3 text-gray-600">
                     @php
                                        $status = strtolower($record->status);
                                        $statusDisplay = ucfirst(str_replace('_', ' ', $status));

                                        // Assign styles based on status
                                        $badgeStyles = match ($status) {
                                            'present' => ['bg' => '#DCFCE7', 'text' => '#166534'],
                                            'absent' => ['bg' => '#FEE2E2', 'text' => '#991B1B'],
                                            'leave' => ['bg' => '#DBEAFE', 'text' => '#1E40AF'],
                                            'half_day' => ['bg' => '#FEF9C3', 'text' => '#854D0E'],
                                            default => ['bg' => '#E5E7EB', 'text' => '#374151'],
                                        };
                                    @endphp

                                    <span class="font-semibold px-2 py-0.5 rounded-2xl text-sm"
                                        style="background-color: {{ $badgeStyles['bg'] }}; color: {{ $badgeStyles['text'] }};">
                                        {{ $statusDisplay }}
                                    </span>
                </td>
                <td class="p-3 text-gray-600">-</td>
              </tr>
              @endforeach
              
            </tbody>
          </table>
          
        </div>
      </div>
    </div>
@endsection

@section('scripts')
@endsection
