@extends('schoolLayout.app')
@section('content')
    <div class="bg-white rounded-xl  shadow-sm">
        <!-- Teacher Profile Intro -->
        <div class="border-b border-gray-200 p-6 mb-6 flex flex-col md:flex-row items-center justify-between">
            <!-- Left: Image + Basic Info -->
            <div class="flex items-center space-x-6">
                <img
                src="{{ $staff && $staff->profile_photo ? url('/staff-members/' . $staff->profile_photo) : asset('assets/sidebar/student.png') }}"
                alt="Teacher Image"
                    class="w-28 h-28 rounded-full object-cover" />
                <div>
                    <h2 class="text-2xl font-bold">{{ $staff->full_name }}</h2>
                    <p><span class="text-gray-500">Employee ID: {{ $staff->registration_no }}</span></p>
                    <p><span class="text-gray-500">Salary Rs: {{ $staff->salary }}</span></p>
                    <p>
                        <span class="text-gray-500"><i
                                class="fa-solid fa-briefcase text-blue-500 mr-2"></i> Job Position: {{ $staff->job_position->title }}</span>
                    </p>
                     <p><span class="text-gray-500">Status: {{ $staff->status }}</span></p>
                    
                </div>
            </div>

            <!-- Right: Update Button -->
            <div class="mt-4 md:mt-0">
                <button class="bg-[#1B9AF5] hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center space-x-2">
                    <i class="fas fa-edit"></i>
                    <span>Update Login</span>
                </button>
            </div>
        </div>
        <!-- Second Section: Personal Info + Employee Details -->
        <div class="rounded-xl shadow-sm px-6 py-2 grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Left: Personal Info -->
            <div class="bg-[#F9FAFB] py-3 px-6 rounded-lg">
                <h3 class="text-lg font-semibold mb-4">Personal Information</h3>
                <div class="space-y-1">
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-envelope text-blue-500 w-6"></i>
                        <span>{{ $staff->email }}</span>
                    </p>
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-phone text-blue-500 w-6"></i>
                        <span>{{ $staff->primary_contact_no }}</span>
                    </p>
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-map-marker-alt text-blue-500 w-6"></i>
                        <span>{{ $staff->address }}</span>
                    </p>
                </div>
            </div>

            <!-- Right: Employee Details -->
            <div class="bg-[#F9FAFB] py-3 px-6 rounded-lg">
                <h3 class="text-lg font-semibold mb-4">Employee Details</h3>
                <div class="space-y-1">
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-briefcase text-blue-500 w-6"></i>
                        <span>{{ $staff->employment_type }}</span>
                    </p>
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-calendar-alt text-blue-500 w-6"></i>
                        <span>Joined: {{ $staff->hire_date }}</span>
                    </p>
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-graduation-cap text-blue-500 w-6"></i>
                        <span>{{ $staff->qualifications }}</span>
                    </p>
                    <p class="flex items-center space-x-2">
                        <i class="fas fa-clock text-blue-500 w-6"></i>
                        <span>Monday - Friday, 8:00 AM - 4:00 PM</span>
                    </p>
                </div>
            </div>
        </div>

        <div class=" p-6 ">
            <h2 class="text-2xl font-semibold mb-4 px-1">Quick Actions</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Card 1 -->
                <div class="flex items-start p-4 border border-gray-200 rounded-lg shadow-sm">
                    <i class="fas fa-calendar-check text-blue-500 text-2xl mr-4 mt-1"></i>
                    <div>
                        <h3 class="text-xl font-semibold">Attendance Records</h3>
                        <p class="text-gray-600 text-sm">View and manage attendance</p>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="flex items-start p-4  py-5 border border-gray-200 rounded-lg shadow-sm">
                    <i class="fas fa-money-check-alt text-blue-500 text-2xl mr-4 mt-1"></i>
                    <div>
                        <h3 class="text-xl font-semibold">Payroll Information</h3>
                        <p class="text-gray-600 text-sm">Access salary details</p>
                    </div>
                </div>

                <!-- Card 3 -->
                <div class="flex items-start p-4  py-5 border border-gray-200 rounded-lg shadow-sm">
                    <i class="fas fa-file-alt text-blue-500 text-2xl mr-4 mt-1"></i>
                    <div>
                        <h3 class="text-xl font-semibold">Documents</h3>
                        <p class="text-gray-600 text-sm">Access important files</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Assigned Subjects Section -->
        <div class="bg-white  px-6 py-3 pb-6">
            <h2 class="text-2xl font-semibold mb-4 px-1">Assigned Subjects</h2>
            <div class="overflow-x-auto">
                <div class="border border-gray-200 rounded-md overflow-hidden">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-gray-100 text-gray-500 text-sm">
                                <th class="px-4 py-2">Subject</th>
                                <th class="px-4 py-2">Class</th>
                                <th class="px-4 py-2">Schedule</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-800 text-sm">
                            @if ($staff->teacher_timetables)
                                @foreach ($staff->teacher_timetables as $subject)
                                    <tr class="border-t">
                                        <td class="px-4 py-2 font-medium">{{ $subject->subjects->name }}</td>
                                        <td class="px-4 py-2">{{ $subject->classes->name }}</td>
                                        <td class="px-4 py-2">{{ $subject->start_time }} - {{ $subject->end_time }}</td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
