@extends('schoolLayout.app')
@section('content')
    <style>
        /* Increase height of the Select2 container */
        .custom-select2+.select2-container .select2-selection--single {
            height: 43px !important;
            display: flex;
            align-items: center;
            border-radius: 0.375rem;
            /* Tailwind's rounded */
            border: 1px solid #d1d5db;
            /* Tailwind gray-300 */
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }

        /* Optional: increase font size */
        .custom-select2+.select2-container .select2-selection__rendered {
            font-size: 16px;
            line-height: 48px;
        }
    </style>
    <div class="bg-[#f9fafc] px-6 rounded">
        <h1 class="text-3xl font-bold mb-3">Staff Ledger</h1>
        <form method="GET" action="{{ route('staff.ledger.get') }}">
            <div class="flex bg-white px-4 rounded shadow-sm py-4 flex-wrap gap-4 items-end mb-6">
                <!-- Staff Name -->
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-gray-700 font-medium mb-1">Staff Name</label>
                    <select name="head_code"
                        class="select2 custom-select2 w-full border rounded pl-3 pr-3 py-2 focus:outline-none">
                        <option value="">Select Staff</option>
                        @foreach ($staffs as $staff)
                            <option value="{{ $staff->head_code }}"
                                {{ old('head_code', $head_code ?? '') == $staff->head_code ? 'selected' : '' }}>
                                {{ $staff->full_name }}
                            </option>
                        @endforeach
                    </select>
                    @error('head_code')
                        <div class="text-red-500 text-sm mt-1">{{ 'Required' }}</div>
                    @enderror
                </div>

                <!-- Start Date -->
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-gray-700 font-medium mb-1">Start Date</label>
                    <div class="relative">
                        <span class="absolute left-3 top-2.5 text-gray-400">
                            <i class="fas fa-calendar-alt"></i>
                        </span>
                        <input type="date" name="start_date"
                            class="w-full border rounded pl-10 pr-3 py-2 focus:outline-none"
                            value="{{ old('start_date', $start_date ?? '') }}" />
                    </div>
                    @error('start_date')
                        <div class="text-red-500 text-sm mt-1">{{ 'Required' }}</div>
                    @enderror
                </div>

                <!-- End Date -->
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-gray-700 font-medium mb-1">End Date</label>
                    <div class="relative">
                        <span class="absolute left-3 top-2.5 text-gray-400">
                            <i class="fas fa-calendar-check"></i>
                        </span>
                        <input type="date" name="end_date"
                            class="w-full border rounded pl-10 pr-3 py-2 focus:outline-none"
                            value="{{ old('end_date', $end_date ?? '') }}" />
                    </div>
                    @error('end_date')
                        <div class="text-red-500 text-sm mt-1">{{ 'Required' }}</div>
                    @enderror
                </div>

                <!-- Search Button -->
                <div class="min-w-[200px]">
                    <button
                        class="mt-6 w-full flex items-center justify-center gap-2 bg-[#1B9AF5] hover:bg-[#1787d1] text-white font-medium py-2.5 px-5 rounded-md">
                        <i class="fas fa-search"></i>
                        Search
                    </button>
                </div>
            </div>
        </form>
        @if (request('head_code') && request('start_date') && request('end_date'))
            <a href="{{ route('pdf.staff.ledger', [
                'head_code' => request('head_code'),
                'start_date' => request('start_date'),
                'end_date' => request('end_date'),
            ]) }}"
                target="_blank" class="inline-block mb-4 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
                <i class="fas fa-file-pdf mr-2"></i> Download PDF
            </a>
        @endif

        <div class="flex text-[#4B5563] gap-6 p-4 bg-white shadow-sm rounded-md">
            <p>
                <span>Reg No:</span>
                <span class="font-semibold">{{ $regNo ?? 'Null' }}</span>
            </p>
            <p>
                <span>Staff name:</span>
                <span class="font-semibold">{{ $staffName ?? 'Null' }}</span>
            </p>
            <p>
                <span>Father name:</span>
                <span class="font-semibold">{{ $fthName ?? 'Null' }}</span>
            </p>
            <p>
                <span>CNIC:</span>
                <span class="font-semibold">{{ $cnic ?? 'Null' }}</span>
            </p>
        </div>

        <!-- Table -->
        <div class="overflow-auto">
            <table class="w-full text-[#4B5563] table-auto text-sm text-left">
                <thead class="bg-[#f9fafc] text-[16px]">
                    <tr class="bg-white py-5">
                        <td class="px-4 py-4 border-b"></td>
                        <td class="px-4 py-4 border-b"></td>
                        <td class="px-4 py-4 border-b">Opening Balance</td>
                        <td class="px-4 py-4 border-b text-right" colspan="3">{{ $staffOpenBalance ?? 0 }}</td>
                    </tr>
                    <tr>
                        <th class="px-4 py-4 border-b">Date</th>
                        <th class="px-4 py-4 border-b">Type</th>
                        <th class="px-4 py-4 border-b">Description</th>
                        <th class="px-4 py-4 border-b text-right">Debit</th>
                        <th class="px-4 py-4 border-b text-right">Credit</th>
                        <th class="px-4 py-4 border-b text-right">Total</th>
                    </tr>
                </thead>
                <tbody class="mt-3 text-[16px] border rounded-xl">
                    @php
                        $totalDebit = 0;
                        $totalCredit = 0;
                        $runningBalance = $staffOpenBalance ?? 0;
                    @endphp

                    @if ($staffLedger->isNotEmpty())
                        @foreach ($staffLedger as $item)
                            @php
                                $totalDebit += $item->debit;
                                $totalCredit += $item->credit;
                                $runningBalance += $item->debit - $item->credit;
                            @endphp
                            <tr class="bg-white py-5">
                                <td class="px-4 py-4 border-b">
                                    {{ \Carbon\Carbon::parse($item->created_at)->format('Y-m-d') }}</td>
                                <td class="px-4 py-4 border-b">{{ $item->transaction_type ?? '-' }}</td>
                                <td class="px-4 py-4 border-b">{{ $item->remarks ?? '-' }}</td>
                                <td class="px-4 py-4 border-b text-right">
                                    {{ $item->debit > 0 ? number_format($item->debit, 2) : '' }}
                                </td>
                                <td class="px-4 py-4 border-b text-right">
                                    {{ $item->credit > 0 ? number_format($item->credit, 2) : '' }}
                                </td>
                                <td class="px-4 py-4 border-b text-right">
                                    {{ number_format($runningBalance, 2) }}
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr class="bg-white py-5">
                            <td class="px-4 py-4 border-b text-center" colspan="6">No record found.</td>
                        </tr>
                    @endif

                    <tr class="py-5">
                        <td class="px-4 py-4 border-b" colspan="3">
                            <div>
                                <p class="bg-[#f9fafc] font-semibold mt-1">Total</p>
                            </div>
                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            {{ number_format($totalDebit, 2) }}
                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            {{ number_format($totalCredit, 2) }}
                        </td>
                        <td class="px-4 py-4 font-semibold border-b text-right">
                            {{ number_format($staffOpenBalance + $totalDebit - $totalCredit, 2) }}
                        </td>
                    </tr>

                </tbody>
            </table>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: "Select Staff",
                allowClear: true,
                width: '100%' // Ensure full width
            });
        });
        // Focus on the search field when the Select2 dropdown opens
        $(document).on('select2:open', function() {
            const searchField = $('.select2-search__field');
            if (searchField.length) {
                searchField[0].focus();
            }
        });
    </script>
@endsection
