<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 6px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-right { text-align: right; }
    </style>
</head>
<body>
    <h2>Staff Payable Report</h2>
    <table>
        <thead>
            <tr>
                <th>Staff Name</th>
                <th>Reg No</th>
                <th>HeadCode</th>
                <th>Status</th>
                <th class="text-right">Debit</th>
                <th class="text-right">Credit</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($staffs as $s)
                <tr>
                    <td>{{ $s->full_name }}</td>
                    <td>{{ $s->registration_no }}</td>
                    <td>{{ $s->head_code }}</td>
                    <td>{{ $s->status }}</td>
                    <td class="text-right">{{ number_format($s->staffDebit, 2) }}</td>
                    <td class="text-right">{{ number_format($s->staffCredit, 2) }}</td>
                    <td class="text-right">{{ number_format($s->staffDebit - $s->staffCredit, 2) }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="4"><strong>Total</strong></td>
                <td class="text-right"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                <td class="text-right"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                <td class="text-right"><strong>{{ number_format($totalDebit - $totalCredit, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</body>
</html>
