<div class="overflow-auto">
    <table class="w-full text-[#4B5563] table-auto text-sm text-left">
        <thead class="bg-[#f9fafc] text-[16px]">
            <tr>
                <th class="px-4 py-4 border-b">Staff Name</th>
                <th class="px-4 py-4 border-b">Reg No</th>
                <th class="px-4 py-4 border-b">HeadCode</th>
                <th class="px-4 py-4 border-b">Status</th>
                <th class="px-4 py-4 border-b text-right">Debit</th>
                <th class="px-4 py-4 border-b text-right">Credit</th>
                <th class="px-4 py-4 border-b text-right">Total</th>
            </tr>
        </thead>
        <tbody class="mt-3 text-[16px] border rounded-xl">
            @foreach ($staffs as $s)
                <tr class="bg-white py-5">
                    <td class="px-4 py-4 border-b">{{ $s->full_name }}</td>
                    <td class="px-4 py-4 border-b">{{ $s->registration_no }}</td>
                    <td class="px-4 py-4 border-b">{{ $s->head_code }}</td>
                    <td class="px-4 py-4 border-b">{{ $s->status }}</td>
                    <td class="px-4 py-4 border-b text-right">{{ number_format($s->staffDebit, 2) }}</td>
                    <td class="px-4 py-4 border-b text-right">{{ number_format($s->staffCredit, 2) }}</td>
                    <td class="px-4 py-4 border-b text-right">
                        {{ number_format($s->staffDebit - $s->staffCredit, 2) }}
                    </td>
                </tr>
            @endforeach

            <tr class="py-5 bg-[#f9fafc]">
                <td class="px-4 py-4 font-semibold border-b" colspan="4">Total</td>
                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalDebit, 2) }}
                </td>
                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalCredit, 2) }}
                </td>
                <td class="px-4 py-4 font-semibold border-b text-right">
                    {{ number_format($totalDebit - $totalCredit, 2) }}
                </td>
            </tr>

        </tbody>
    </table>
</div>
