@extends('schoolLayout.app')
@section('content')
@include('successError')
    <header class="bg-white w-[96%] mx-auto shadow-sm px-4 py-2 flex justify-between items-center mb-1 mx-auto rounded-sm">
        <!-- Left: Heading -->
        <h1 class="text-2xl font-semibold text-gray-800">
            Add Staff
        </h1>

        <!-- Right: Image -->
        <img src="{{ asset('assets/hrProfile.png') }}" alt="Header Image" class="w-8 rounded-full object-cover" />
    </header>
    <div class="bg-[#f9fafc] rounded-lg p-6 w-[96%] mx-auto">
        <div class="bg-white p-4 rounded-lg">
            <form action="{{ route('staff.store') }}" method="POST" enctype="multipart/form-data" class="w-full">
                @csrf
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">1. Personal Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Full Name<span class="text-red-600">*</span></label>
                            <input type="text" name="name" id="name" class="p-2 border rounded-md w-full"
                                placeholder="Enter your name" value="{{ old('name') }}" />
                            @error('name')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Father Name<span class="text-red-600">*</span></label>
                            <input type="text" name="fth_name" id="fth_name" class="p-2 border rounded-md w-full"
                                placeholder="Enter father's name" value="{{ old('fth_name') }}" />
                            @error('fth_name')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Email<span class="text-red-600">*</span></label>
                            <input type="email" name="email" id="email" class="p-2 border rounded-md w-full"
                                placeholder="Enter email address" value="{{ old('email') }}" />
                            @error('email')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="block mb-1">Gender <span class="text-red-600">*</span></label>
                            <select name="gender" id="gender"
                                class="w-full p-2 border rounded @error('gender') border-red-500 @enderror">
                                <option value="">Select Gender</option>
                                <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                                <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                                <option value="Other" {{ old('gender') == 'Other' ? 'selected' : '' }}>Other</option>
                            </select>
                            @error('gender')
                                <p class="text-red-500 text-sm">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block mb-1">CNIC <span class="text-red-600">*</span></label>
                            <input type="text" name="cnic" id="cnic"
                                class="w-full p-2 border rounded @error('cnic') border-red-500 @enderror"
                                value="{{ old('cnic') }}">
                            @error('cnic')
                                <p class="text-red-500 text-sm">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Date of Birth<span class="text-red-600">*</span></label>
                            <input type="date" name="dob" id="dob" class="p-2 border rounded-md w-full"
                                value="{{ old('dob') }}" />
                            @error('dob')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">2. Contact Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Primary Contact No.</label>
                            <input type="tel" name="primary_cont" id="primary_cont" class="p-2 border rounded-md w-full"
                                placeholder="Enter primary contact number" value="{{ old('primary_cont') }}" />
                            @error('primary_cont')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Secondary Contact No</label>
                            <input type="tel" name="secondary_cont" class="p-2 border rounded-md w-full"
                                placeholder="Enter secondary contact number" value="{{ old('secondary_cont') }}" />
                            @error('secondary_cont')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div>
                        <label class="mb-1 block font-semibold text-gray-700">Address</label>
                        <textarea name="address" id="address" class="p-2 border rounded-md w-full h-24 resize-none"
                            placeholder="Enter address">{{ old('address') }}</textarea>
                        @error('address')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <!-- Professional Details -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">3. Professional Details</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Position Category</label>
                            <select name="position" id="position" class="p-2 border rounded-md w-full bg-white">
                                <option value="" disabled selected>Position Category</option>
                                @if ($positions)
                                    @foreach ($positions as $position)
                                        <option value="{{ $position->id }}">{{ $position->category }}</option>
                                    @endforeach
                                @endif
                            </select>
                            @error('position')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Employment Type</label>
                            <select name="emp_type" id="emp_type" class="p-2 border rounded-md w-full">
                                <option value="" disabled selected>Select Type</option>
                                <!-- Add options dynamically if needed -->
                                <option value="Full time">Full time</option>
                                <option value="half time">Half time</option>
                            </select>
                            @error('emp_type')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Salary</label>
                            <input type="number" name="salary" id="salary" class="p-2 border rounded-md w-full"
                                placeholder="Enter salary" value="{{ old('salary') }}" />
                            @error('salary')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <label class="mb-1 block font-semibold text-gray-700">Previous Experience (Years)</label>
                            <input type="number" name="prev_exp" id="prev_exp" class="p-2 border rounded-md w-full"
                                placeholder="Enter experience years" value="{{ old('prev_exp') }}" />
                            @error('prev_exp')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="md:col-span-2">
                            <label class="mb-1 block font-semibold text-gray-700">Qualifications</label>
                            <textarea name="qualif" id="qualif" class="p-2 border rounded-md w-full h-24 resize-none"
                                placeholder="Enter educational qualifications">{{ old('qualif') }}</textarea>
                            @error('qualif')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Documents Upload -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">4. Documents Upload</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                        <div>
                            <p class="block font-semibold mb-1">Profile Photo</p>
                            <label
                                class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                                <img src="{{ asset('assets/upload.png') }}" alt="icon" />
                                <span class="text-sm text-gray-500 mt-2">
                                    <span class="text-black">Upload a file </span>or Drag and drop
                                </span>
                                <span class="text-xs text-gray-400 mt-1">PNG, JPG up to 5MB</span>
                                <input type="file" name="photo" id="photo" class="hidden" accept="image/png, image/jpeg" />
                                <div id="photoPreview" class="mt-2"></div>
                            </label>
                            @error('photo')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <p class="block font-semibold mb-1">CV/Resume</p>
                            <label
                                class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                                <img src="{{ asset('assets/cv.png') }}" alt="icon" />
                                <span class="text-sm text-gray-500 mt-2">
                                    <span class="text-black">Upload CV </span>or Drag and drop
                                </span>
                                <span class="text-xs text-gray-400 mt-1">PDF, DOC up to 5MB</span>
                                <input type="file" name="cv" id="cv" class="hidden" accept=".pdf, .doc, .docx" />
                                <div id="cvPreview" class="mt-2"></div>
                            </label>
                            @error('cv')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <p class="block font-semibold mb-1">Degree Certificate</p>
                            <label
                                class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                                <img src="{{ asset('assets/degree.png') }}" alt="icon" />
                                <span class="text-sm text-gray-500 mt-2">
                                    <span class="text-black">Upload Degree </span>or Drag and drop
                                </span>
                                <span class="text-xs text-gray-400 mt-1">PDF, DOC up to 5MB</span>
                                <input type="file" name="degree" id="degree" class="hidden" accept=".pdf, .doc, .docx" />
                                <div id="degreePreview" class="mt-2"></div>
                            </label>
                            @error('degree')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                        <div>
                            <p class="block font-semibold mb-1">Transcript</p>
                            <label
                                class="w-full flex flex-col h-28 items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer hover:border-blue-500">
                                <img src="{{ asset('assets/transcript.png') }}" alt="icon" />
                                <span class="text-sm text-gray-500 mt-2">
                                    <span class="text-black">Upload Transcript </span>or Drag and drop
                                </span>
                                <span class="text-xs text-gray-400 mt-1">PNG, JPG up to 5MB</span>
                                <input type="file" name="transcript" id="transcript" class="hidden" accept="image/png, image/jpeg" />
                                <div id="transcriptPreview" class="mt-2"></div>
                            </label>
                            @error('transcript')
                                <span class="text-red-500 text-sm">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Additional Information -->
                <div class="bg-white rounded-lg p-4 my-4">
                    <h3 class="text-lg font-semibold text-gray-600 mb-1">5. Additional Information</h3>
                    <div class="mb-4">
                        <label class="mb-1 block font-semibold text-gray-700">Additional Notes</label>
                        <textarea name="notes" class="p-2 border rounded-md w-full h-20"
                            placeholder="Enter any additional information">{{ old('notes') }}</textarea>
                        @error('notes')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end gap-x-4">
                    <button type="button" class="border px-2 rounded-md border-gray-400"
                        onclick="window.location.href='{{ route('staff') }}'">Cancel</button>
                    <button type="submit" class="bg-[#0197FF] text-white p-2 rounded-md hover:bg-blue-700 transition">
                        Submit
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.19.5/jquery.validate.min.js"></script>
<script>
$(document).ready(function () {
    // jQuery Validation
    $("form#updateStaffForm, form[action='{{ route('staff.store') }}']").validate({
        rules: {
            name: { required: true },
            fth_name: { required: true },
            email: { required: true, email: true },
            cnic: { required: true },
            gender: { required: true },
            dob: { required: true },
            primary_cont: { required: true },
            address: { required: true },
            position: { required: true },
            emp_type: { required: true },
            photo: { extension: "jpg|jpeg|png", filesize: 5 * 1024 * 1024 },
            cv: { extension: "pdf|doc|docx", filesize: 5 * 1024 * 1024 },
            degree: { extension: "pdf|doc|docx", filesize: 5 * 1024 * 1024 },
            transcript: { extension: "jpg|jpeg|png", filesize: 5 * 1024 * 1024 }
        },
        messages: {
            photo: { extension: "Only JPG, JPEG, PNG allowed", filesize: "Max size 5MB" },
            cv: { extension: "Only PDF, DOC, DOCX allowed", filesize: "Max size 5MB" },
            degree: { extension: "Only PDF, DOC, DOCX allowed", filesize: "Max size 5MB" },
            transcript: { extension: "Only JPG, JPEG, PNG allowed", filesize: "Max size 5MB" }
        },
        errorClass: "text-red-500 text-sm",
        errorElement: "span",
        highlight: function(element) {
            $(element).addClass('border-red-500');
        },
        unhighlight: function(element) {
            $(element).removeClass('border-red-500');
        }
    });

    // File size validation method
    $.validator.addMethod('filesize', function (value, element, param) {
        return this.optional(element) || (element.files[0].size <= param);
    });

    // File preview function
    function previewFile(input, previewId, type) {
        const file = input.files[0];
        const preview = $("#" + previewId);
        preview.html(""); // Clear previous preview

        if (file) {
            if (type === "image" && file.type.match('image.*')) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    preview.html('<img src="' + e.target.result + '" class="h-20 mx-auto" />');
                };
                reader.readAsDataURL(file);
            } else if (type === "pdf" && file.type === "application/pdf") {
                preview.html('<embed src="' + URL.createObjectURL(file) + '" type="application/pdf" width="100%" height="100px" />');
            } else if (type === "doc") {
                preview.html('<span class="text-gray-500">File selected: ' + file.name + '</span>');
            }
        }
    }

    // Bind preview for each file input
    $("#photo").on("change", function () {
        previewFile(this, "photoPreview", "image");
    });
    $("#cv").on("change", function () {
        const file = this.files[0];
        if (file && file.type === "application/pdf") {
            previewFile(this, "cvPreview", "pdf");
        } else {
            previewFile(this, "cvPreview", "doc");
        }
    });
    $("#degree").on("change", function () {
        const file = this.files[0];
        if (file && file.type === "application/pdf") {
            previewFile(this, "degreePreview", "pdf");
        } else {
            previewFile(this, "degreePreview", "doc");
        }
    });
    $("#transcript").on("change", function () {
        previewFile(this, "transcriptPreview", "image");
    });
});
</script>
