<!DOCTYPE html>
<html>
<head>
    <title>Staff List</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #333; padding: 8px; text-align: left; }
        th { background-color: #f0f0f0; }
    </style>
</head>
<body>
    <h2>Current Staff Members</h2>

    <table>
        <thead>
            <tr>
                <th>Employee</th>
                <th>Job Category</th>
                <th>Qualification</th>
                <th>Status</th>
                <th>Registration No</th>
                <th>Email</th>
                <th>CNIC</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($staff as $member)
                <tr>
                    <td>{{ $member->full_name }}</td>
                    <td>{{ optional($member->job_position)->category ?? '-' }}</td>
                    <td>{{ $member->qualifications }}</td>
                    <td>{{ ucfirst($member->status) }}</td>
                    <td>{{ $member->registration_no }}</td>
                    <td>{{ $member->email }}</td>
                    <td>{{ $member->cnic }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
