<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign In - School Management System</title>
    <script src="https://kit.fontawesome.com/ee244dc737.js" crossorigin="anonymous"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
</head>
<body class="bg-[#f9fafc] flex flex-col min-h-screen justify-center items-center font-[Roboto]">

    <div class="w-full max-w-md px-4 md:px-0">

        <!-- Logo -->
        <div class="flex justify-center">
        <img src="{{ asset('assets/logo.svg') }}" alt="logo" class="w-14"/>

        </div>

        <!-- Heading -->
        <h2 class="text-3xl font-bold text-gray-800 text-center">School Management System</h2>
        <p class="text-gray-600 text-center mt-2">Welcome back! Please login to your account.</p>

        <!-- Session Status -->
        @if (session('status'))
            <div class="mt-4 text-green-600 text-sm text-center font-medium">
                {{ session('status') }}
            </div>
        @endif

        <!-- Login Form -->
        <form method="POST" action="{{ route('login') }}" class="mt-6 rounded-lg shadow-sm bg-white p-4 py-6 md:p-8">
            @csrf

            <!-- Email Address -->
            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-1">Email or Username</label>
                <div class="flex items-center border rounded-lg p-2">
                    <i class="fa-solid fa-envelope text-[#9CA3AF]"></i>
                    <input type="email" id="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="username" placeholder="Enter your email" class="ml-2 w-full outline-none bg-transparent">
                </div>
                @error('email')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password -->
            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-1">Password</label>
                <div class="flex items-center border rounded-lg p-2">
                    <i class="fa-solid fa-lock text-[#9CA3AF]"></i>
                    <input type="password" id="password" name="password" required autocomplete="current-password" placeholder="Enter your password" class="ml-2 w-full outline-none bg-transparent">
                    <button type="button" id="togglePassword" tabindex="-1">
                        <i class="fa-solid fa-eye text-[#9CA3AF] cursor-pointer"></i>
                    </button>
                </div>
                @error('password')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Remember Me & Forgot Password -->
            <div class="flex justify-between items-center text-sm text-gray-600">
                <label class="flex items-center">
                    <input id="remember_me" type="checkbox" name="remember" class="mr-2">
                    Remember me
                </label>
                @if (Route::has('password.request'))
                    <a href="{{ route('password.request') }}" class="text-blue-600 hover:underline">Forgot password?</a>
                @endif
            </div>

            <!-- Sign In Button -->
            <button class="w-full mt-6 bg-[#1B9AF5] text-white py-2 rounded-md transition">
                Sign In
            </button>
        </form>
    </div>

    <!-- Footer -->
    <footer class="text-center absolute bottom-2 text-gray-600 text-sm mt-6">
        <p>© 2025 School Management System. All rights reserved.</p>
        <p>Version 1.0.0</p>
    </footer>

    <script>
        const passwordInput = document.getElementById("password");
        const togglePassword = document.getElementById("togglePassword");
        const toggleIcon = togglePassword.querySelector("i");

        togglePassword.addEventListener("click", () => {
            if (passwordInput.type === "password") {
                passwordInput.type = "text";
                toggleIcon.classList.remove("fa-eye");
                toggleIcon.classList.add("fa-eye-slash");
            } else {
                passwordInput.type = "password";
                toggleIcon.classList.remove("fa-eye-slash");
                toggleIcon.classList.add("fa-eye");
            }
        });
    </script>
</body>
</html>
