@extends('schoolLayout.app')

@section('content')
    <div class="w-full mx-auto bg-[#f9fafc] mt-10 p-8 rounded-lg shadow-md">
        <h2 class="text-2xl mb-6">Update Settings</h2>

        <form action="{{ route('settings.update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            @if (session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4">
                    <strong class="font-bold">Error:</strong>
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif

            @if (session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                    <strong class="font-bold">Success:</strong>
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="flex">
                    @if (!empty($logo->setting_value))
                        
                        <img src="{{ url('school-logo/'.$logo->setting_value) }}" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1">{{ ucfirst(str_replace('_', ' ', $logo->setting_key)) }}</label>
                            <input type="file" name="school_logo"
                                class="w-full p-2 border rounded">
                        </div>
                    @else
                        <img src="{{ asset('assets/logo.png') }}" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1">{{ ucfirst(str_replace('_', ' ', 'school_logo')) }}</label>
                            <input type="file" name="school_logo"
                                class="w-full p-2 border rounded">
                        </div>
                    @endif
                    {{-- <img src="{{ asset('storage/'.$logo->setting_value) }}" alt=""> --}}
                        
                </div>
                @foreach ($settings as $setting)
                    <div>
                        <label class="block mb-1">{{ ucfirst(str_replace('_', ' ', $setting->setting_key)) }}</label>
                        <input type="text" name="settings[{{ $setting->setting_key }}]"
                            class="w-full p-2 border rounded @error('settings.' . $setting->setting_key) border-red-500 @enderror"
                            value="{{ old('settings.' . $setting->setting_key, $setting->setting_value) }}">
                        @error('settings.' . $setting->key)
                            <p class="text-red-500 text-sm">{{ $message }}</p>
                        @enderror
                    </div>
                @endforeach
                
                <div class="flex">
                    @if (!empty($controller_signature->setting_value))
                        <img src="{{ url('school-logo/'.$controller_signature->setting_value) }}" alt="" width="100" height="100" style="border-radius: 5px">
                        <div class="px-5">
                            <label class="block mb-1">{{ ucfirst(str_replace('_', ' ', $controller_signature->setting_key)) }}</label>
                            <input type="file" name="exam_controller_sign"
                                class="w-full p-2 border rounded">
                        </div>
                    @endif
                         
                </div>

            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Update Settings</button>
            </div>
        </form>
    </div>
@endsection
