@extends('schoolLayout.app')
@section('content')
    @include('successError')
    <div class="bg-[#f9fafc] min-h-screen px-8 py-4">
        <!-- Top Section: Tabs & Button -->
        <div class="flex justify-between items-center">
            <!-- Tabs:-->
            <div class="flex space-x-2 w-[50%]">
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick=" window.location.href = '{{ route('school-sessions') }}'">
                    Sessions
                </button>
                <button class="tab-btn px-8 pb-3 bg-white py-2 border-b-2 border-blue-500 font-semibold text-blue-500">
                    Sections
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '{{ route('classes') }}'">
                    Classes
                </button>
                <button class="tab-btn pb-3 px-8 text-gray-700 font-semibold"
                    onclick="window.location.href = '{{ route('subjects') }}'">
                    Subjects
                </button>
            </div>
            <a href="{{ route('pdf.section.list') }}" target="_blank"
                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-700">
                Section PDF
            </a>

            <button class="px-4 py-2 bg-[#0197FF] flex items-center gap-x-4 text-white rounded-md" id="openModal">
                <i class="fa-solid fa-plus"></i>
                <span>Add New Sections</span>
            </button>
        </div>

        <div class="border p-3 bg-white border-gray-200 rounded-lg my-4">

            <div class="relative bg-white">
                <table class="w-full border-collapse">
                    <thead class="bg-[#f9fafc]">
                        <tr class="text-gray-600">
                            <th class="p-3 text-left text-gray-500 font-medium">ID</th>
                            <th class="p-3 text-left text-gray-500 font-medium">Section</th>
                            {{-- <th class="p-3 text-left text-gray-500 font-medium">Class</th> --}}
                            <th class="p-3 text-left text-gray-500 font-medium">
                                Capacity
                            </th>
                            <th class="p-3 text-center text-gray-500 font-medium">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white py-3 rounded-lg">
                        @if ($sections)
                            @foreach ($sections as $index => $section)
                                <tr class="border-b">
                                    <td class="p-3 flex items-center font-semibold text-black">
                                        {{ $index + 1 }}
                                    </td>
                                    <td class="p-3 text-gray-500">{{ $section->name }}</td>
                                    {{-- <td class="p-3 text-gray-500">Class 1</td> --}}
                                    <td class="p-3 text-gray-500">{{ $section->capacity }}</td>
                                    <td class="p-3 text-center flex justify-center items-center gap-x-4">
                                        <i class="fa-solid fa-pen-to-square text-blue-500 cursor-pointer"
                                            onclick="openEditModal({
                             id: '{{ $section->id }}',
                             name: '{{ $section->name }}',
                             capacity: '{{ $section->capacity }}'
                         })"></i>
                                        {{--    <i class="fa-solid fa-trash text-red-500 cursor-pointer"
                                            onclick="deleteSection('{{ $section->id }}')"></i> --}}
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add Section Modal -->
    <div id="modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-md rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Create New Section</h2>
                <button id="closeModal" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form action="{{ route('store.sections') }}" method="POST" class="bg-white px-6 py-3">
                @csrf
                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Section Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" placeholder="A, B, C, etc." name="name" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Capacity <span class="text-red-500">*</span>
                    </label>
                    <input type="number" placeholder="40" name="capacity" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" id="closeModalBtn"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Create Section
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Edit Section Modal -->
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white w-full max-w-md rounded-lg shadow-lg relative max-h-[80vh] overflow-y-auto">
            <div class="flex items-center px-4 py-6 border-b border-gray-200 justify-between">
                <h2 class="text-xl font-semibold">Edit Section</h2>
                <button onclick="closeEditModal()" class="text-gray-600 hover:text-gray-900">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>

            <form id="editSectionForm" method="POST" class="bg-white px-6 py-3">
                @csrf
                @method('PUT')
                <input type="hidden" id="editSectionId" name="id">

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Section Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" id="editSectionName" name="name" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 font-semibold mb-1">
                        Capacity <span class="text-red-500">*</span>
                    </label>
                    <input type="number" id="editSectionCapacity" name="capacity" required
                        class="w-full border border-gray-300 p-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div class="flex justify-end border-t border-gray-200 bg-[#f9fafc] px-6 py-3 space-x-3">
                    <button type="button" onclick="closeEditModal()"
                        class="px-4 py-2 border border-gray-500 text-gray-800 rounded">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-[#0197FF] text-white rounded hover:bg-blue-700">
                        Update Section
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Add Section Modal functionality
        const modal = document.getElementById("modal");
        const openModalBtn = document.getElementById("openModal");
        const closeModalBtns = [
            document.getElementById("closeModal"),
            document.getElementById("closeModalBtn"),
        ];

        openModalBtn.addEventListener("click", () => {
            modal.classList.remove("hidden");
        });

        closeModalBtns.forEach((btn) => {
            btn.addEventListener("click", () => {
                modal.classList.add("hidden");
            });
        });

        // Edit Section Modal functionality
        function openEditModal(section) {
            document.getElementById('editSectionId').value = section.id;
            document.getElementById('editSectionName').value = section.name;
            document.getElementById('editSectionCapacity').value = section.capacity;
            document.getElementById('editSectionForm').action = `/section/update/${section.id}`;
            document.getElementById('editModal').classList.remove('hidden');
        }

        function closeEditModal() {
            document.getElementById('editModal').classList.add('hidden');
        }

        /*  function deleteSection(sectionId) {
              if (confirm('Are you sure you want to delete this section?')) {
                  // Create a form dynamically
                  const form = document.createElement('form');
                  form.method = 'GET';
                  form.action = `/section/delete/${sectionId}`;


                  // Add CSRF token directly from Laravel
                  const csrf = document.createElement('input');
                  csrf.type = 'hidden';
                  csrf.name = '_token';
                  csrf.value = '{{ csrf_token() }}'; // This will work if the function is in your Blade template
                  form.appendChild(csrf);

                  // Submit the form
                  document.body.appendChild(form);
                  form.submit();
              }
          }*/

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
            if (event.target === document.getElementById('editModal')) {
                closeEditModal();
            }
        }
    </script>
@endsection
