<!DOCTYPE html>
<html>
<head>
    <title>Section List</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th, td {
            border: 1px solid #999;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h2>Section List</h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Section Name</th>
                <th>Capacity</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sections as $index => $section)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $section->name }}</td>
                    <td>{{ $section->capacity }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
