<nav class="bg-white fixed z-50 top-0 left-0 w-full shadow-sm px-6 pr-14 py-3 flex items-center justify-end">
        <!-- Notification, Email, and Profile -->
        <div class="flex items-center gap-6 relative">
            <i class="fa-solid fa-bell text-xl text-gray-500 cursor-pointer"></i>
            <i class="fa-solid fa-envelope text-xl text-gray-500 cursor-pointer"></i>
            
            <!-- Profile Image -->
            <div class="relative">
                <img id="profileButton" src="{{ asset('assets/teacher.png') }}" alt="profile" class="w-10 h-10 rounded-full object-cover cursor-pointer">
                
                <!-- Dropdown Menu -->
                <div id="dropdownMenu" class="absolute right-0 mt-2 w-48 bg-white shadow-lg rounded-lg py-2 hidden">
                    <a href="#" class="flex items-center px-4 py-2 text-gray-700 hover:bg-gray-100">
                        <i class="fa-solid fa-user text-lg mr-3"></i> View Profile
                    </a>

                    <form method="POST" action="{{ route('logout') }}">
                            @csrf 

                   <a  onclick="event.preventDefault();  this.closest('form').submit();" href="{{route('logout')}}" class="flex items-center px-4 py-2 text-red-600 hover:bg-gray-100">
                        <i class="fa-solid fa-sign-out-alt text-lg mr-3"></i>  {{ __('Log Out') }}
                    </a> 
                </form>
                </div>
            </div>
        </div>
    </nav>

    <script>
        const profileButton = document.getElementById("profileButton");
        const dropdownMenu = document.getElementById("dropdownMenu");

        // Toggle dropdown on profile image click
        profileButton.addEventListener("click", (event) => {
            event.stopPropagation(); // Prevent click from closing immediately
            dropdownMenu.classList.toggle("hidden");
        });

        // Close dropdown when clicking outside
        document.addEventListener("click", (event) => {
            if (!dropdownMenu.contains(event.target) && event.target !== profileButton) {
                dropdownMenu.classList.add("hidden");
            }
        });
    </script>
