<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <link rel="shortcut icon" href="{{ asset('assets/favicon.svg') }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.title') }}</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/ee244dc737.js" crossorigin="anonymous"></script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
  
    <!-- Select2 CSS & JS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

</head>

<body class="bg-gray-100">

    <!-- Sidebar Included Here -->
    <div id="sidebar-container">
        @include('schoolLayout.sidebar')
    </div>

    <!-- Navbar Included Here -->
    <div id="navbar-container">
        @include('schoolLayout.navbar')
    </div>


    {{-- contents --}}
    <div id="main-content" class="ml-64 mt-20 px-3">
        @yield('content')
    </div>

</body>
@yield('script')
<script>
    function toggleDropdown(button) {
        document.querySelectorAll(".action-dropdown").forEach((dropdown) => {
            if (dropdown !== button.nextElementSibling) {
                dropdown.classList.add("hidden");
            }
        });

        button.nextElementSibling.classList.toggle("hidden");
    }
</script>

</html>
